package com.xforceplus.seller.config.client.model;

import java.io.Serializable;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 用户自定义导出字段
 */
@ApiModel(description = "用户自定义导出字段")

@JsonInclude(NON_NULL)
public class MsImportField implements Serializable {
  @JsonProperty("fieldCode")
  private String fieldCode = null;

  @JsonProperty("fieldName")
  private String fieldName = null;

  @JsonIgnore
  public MsImportField fieldCode(String fieldCode) {
    this.fieldCode = fieldCode;
    return this;
  }

   /**
   * 字段代码
   * @return fieldCode
  **/
  @ApiModelProperty(value = "字段代码")
  public String getFieldCode() {
    return fieldCode;
  }

  public void setFieldCode(String fieldCode) {
    this.fieldCode = fieldCode;
  }

  @JsonIgnore
  public MsImportField fieldName(String fieldName) {
    this.fieldName = fieldName;
    return this;
  }

   /**
   * 字段名称
   * @return fieldName
  **/
  @ApiModelProperty(value = "字段名称")
  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsImportField importField = (MsImportField) o;
    return Objects.equals(this.fieldCode, importField.fieldCode) &&
        Objects.equals(this.fieldName, importField.fieldName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldCode, fieldName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsImportField {\n");
    
    sb.append("    fieldCode: ").append(toIndentedString(fieldCode)).append("\n");
    sb.append("    fieldName: ").append(toIndentedString(fieldName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
