package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 元数据对象查询请求
 */
@ApiModel(description = "元数据对象查询请求")

@JsonInclude(NON_NULL)
public class MsMataDataQueryRequestWithUserInfo {
  @JsonProperty("objCode")
  private String objCode = null;

  @JsonProperty("objName")
  private String objName = null;

  @JsonProperty("objType")
  private String objType = null;

  @JsonProperty("objStatus")
  private Integer objStatus = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("userInfo")
  private MsCommonUserInfo userInfo = null;

  @JsonIgnore
  public MsMataDataQueryRequestWithUserInfo objCode(String objCode) {
    this.objCode = objCode;
    return this;
  }

   /**
   * null
   * @return objCode
  **/
  @ApiModelProperty(value = "null")
  public String getObjCode() {
    return objCode;
  }

  public void setObjCode(String objCode) {
    this.objCode = objCode;
  }

  @JsonIgnore
  public MsMataDataQueryRequestWithUserInfo objName(String objName) {
    this.objName = objName;
    return this;
  }

   /**
   * null
   * @return objName
  **/
  @ApiModelProperty(value = "null")
  public String getObjName() {
    return objName;
  }

  public void setObjName(String objName) {
    this.objName = objName;
  }

  @JsonIgnore
  public MsMataDataQueryRequestWithUserInfo objType(String objType) {
    this.objType = objType;
    return this;
  }

   /**
   * 房地产 酒店等业务类型 为中文描述
   * @return objType
  **/
  @ApiModelProperty(value = "房地产 酒店等业务类型 为中文描述")
  public String getObjType() {
    return objType;
  }

  public void setObjType(String objType) {
    this.objType = objType;
  }

  @JsonIgnore
  public MsMataDataQueryRequestWithUserInfo objStatus(Integer objStatus) {
    this.objStatus = objStatus;
    return this;
  }

   /**
   * 状态码
   * @return objStatus
  **/
  @ApiModelProperty(value = "状态码")
  public Integer getObjStatus() {
    return objStatus;
  }

  public void setObjStatus(Integer objStatus) {
    this.objStatus = objStatus;
  }

  @JsonIgnore
  public MsMataDataQueryRequestWithUserInfo groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 公司ID
   * @return groupId
  **/
  @ApiModelProperty(value = "公司ID")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsMataDataQueryRequestWithUserInfo pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 当前页数
   * @return pageNo
  **/
  @ApiModelProperty(value = "当前页数")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public MsMataDataQueryRequestWithUserInfo pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页数量
   * @return pageSize
  **/
  @ApiModelProperty(value = "每页数量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsMataDataQueryRequestWithUserInfo userInfo(MsCommonUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * 用户信息
   * @return userInfo
  **/
  @ApiModelProperty(value = "用户信息")
  public MsCommonUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsCommonUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsMataDataQueryRequestWithUserInfo mataDataQueryRequestWithUserInfo = (MsMataDataQueryRequestWithUserInfo) o;
    return Objects.equals(this.objCode, mataDataQueryRequestWithUserInfo.objCode) &&
        Objects.equals(this.objName, mataDataQueryRequestWithUserInfo.objName) &&
        Objects.equals(this.objType, mataDataQueryRequestWithUserInfo.objType) &&
        Objects.equals(this.objStatus, mataDataQueryRequestWithUserInfo.objStatus) &&
        Objects.equals(this.groupId, mataDataQueryRequestWithUserInfo.groupId) &&
        Objects.equals(this.pageNo, mataDataQueryRequestWithUserInfo.pageNo) &&
        Objects.equals(this.pageSize, mataDataQueryRequestWithUserInfo.pageSize) &&
        Objects.equals(this.userInfo, mataDataQueryRequestWithUserInfo.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(objCode, objName, objType, objStatus, groupId, pageNo, pageSize, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsMataDataQueryRequestWithUserInfo {\n");
    
    sb.append("    objCode: ").append(toIndentedString(objCode)).append("\n");
    sb.append("    objName: ").append(toIndentedString(objName)).append("\n");
    sb.append("    objType: ").append(toIndentedString(objType)).append("\n");
    sb.append("    objStatus: ").append(toIndentedString(objStatus)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
