package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 标准响应头
 */
@ApiModel(description = "标准响应头")

@JsonInclude(NON_NULL)
public class MsResponseHead {
  @JsonProperty("code")
  private Integer code = 1;

  @JsonProperty("subCode")
  private String subCode = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("timestamp")
  private String timestamp = null;

  @JsonProperty("timeCost")
  private Long timeCost = null;

  @JsonIgnore
  public MsResponseHead code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 返回代码 正数成功, 负数失败
   * @return code
  **/
  @ApiModelProperty(value = "返回代码 正数成功, 负数失败")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsResponseHead subCode(String subCode) {
    this.subCode = subCode;
    return this;
  }

   /**
   * 返回子代码 不一定有值，一般用来编码更具体的处理结果。调用方可以用来映射自定义的Message。
   * @return subCode
  **/
  @ApiModelProperty(value = "返回子代码 不一定有值，一般用来编码更具体的处理结果。调用方可以用来映射自定义的Message。")
  public String getSubCode() {
    return subCode;
  }

  public void setSubCode(String subCode) {
    this.subCode = subCode;
  }

  @JsonIgnore
  public MsResponseHead message(String message) {
    this.message = message;
    return this;
  }

   /**
   * 返回信息
   * @return message
  **/
  @ApiModelProperty(value = "返回信息")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsResponseHead timestamp(String timestamp) {
    this.timestamp = timestamp;
    return this;
  }

   /**
   * 时间戳
   * @return timestamp
  **/
  @ApiModelProperty(value = "时间戳")
  public String getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(String timestamp) {
    this.timestamp = timestamp;
  }

  @JsonIgnore
  public MsResponseHead timeCost(Long timeCost) {
    this.timeCost = timeCost;
    return this;
  }

   /**
   * 耗时
   * @return timeCost
  **/
  @ApiModelProperty(value = "耗时")
  public Long getTimeCost() {
    return timeCost;
  }

  public void setTimeCost(Long timeCost) {
    this.timeCost = timeCost;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsResponseHead responseHead = (MsResponseHead) o;
    return Objects.equals(this.code, responseHead.code) &&
        Objects.equals(this.subCode, responseHead.subCode) &&
        Objects.equals(this.message, responseHead.message) &&
        Objects.equals(this.timestamp, responseHead.timestamp) &&
        Objects.equals(this.timeCost, responseHead.timeCost);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, subCode, message, timestamp, timeCost);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsResponseHead {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    subCode: ").append(toIndentedString(subCode)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    timeCost: ").append(toIndentedString(timeCost)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
