package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 设备信息
 */
@ApiModel(description = "设备信息")

@JsonInclude(NON_NULL)
public class MsTaxDeviceQueryRequestInfo {
  @JsonProperty("invoiceType")
  private List<String> invoiceType = new ArrayList<String>();

  @JsonProperty("taxDeviceType")
  private Integer taxDeviceType = null;

  @JsonProperty("taxDeviceMachineNo")
  private String taxDeviceMachineNo = null;

  @JsonIgnore
  public MsTaxDeviceQueryRequestInfo invoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

  public MsTaxDeviceQueryRequestInfo addInvoiceTypeItem(String invoiceTypeItem) {
    this.invoiceType.add(invoiceTypeItem);
    return this;
  }

   /**
   * 发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）")
  public List<String> getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsTaxDeviceQueryRequestInfo taxDeviceType(Integer taxDeviceType) {
    this.taxDeviceType = taxDeviceType;
    return this;
  }

   /**
   * 1 百望单盘 2 百望服务器  3 航信单盘 4 航信服务器
   * @return taxDeviceType
  **/
  @ApiModelProperty(value = "1 百望单盘 2 百望服务器  3 航信单盘 4 航信服务器 5 虚拟UKey设备 6 税务UKey设备（old 不用了，现用8） 7 税务证书 8 税务UKey设备")
  public Integer getTaxDeviceType() {
    return taxDeviceType;
  }

  public void setTaxDeviceType(Integer taxDeviceType) {
    this.taxDeviceType = taxDeviceType;
  }

  @JsonIgnore
  public MsTaxDeviceQueryRequestInfo taxDeviceMachineNo(String taxDeviceMachineNo) {
    this.taxDeviceMachineNo = taxDeviceMachineNo;
    return this;
  }

   /**
   * 开票机号
   * @return taxDeviceMachineNo
  **/
  @ApiModelProperty(value = "开票机号")
  public String getTaxDeviceMachineNo() {
    return taxDeviceMachineNo;
  }

  public void setTaxDeviceMachineNo(String taxDeviceMachineNo) {
    this.taxDeviceMachineNo = taxDeviceMachineNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTaxDeviceQueryRequestInfo taxDeviceQueryRequestInfo = (MsTaxDeviceQueryRequestInfo) o;
    return Objects.equals(this.invoiceType, taxDeviceQueryRequestInfo.invoiceType) &&
        Objects.equals(this.taxDeviceType, taxDeviceQueryRequestInfo.taxDeviceType) &&
        Objects.equals(this.taxDeviceMachineNo, taxDeviceQueryRequestInfo.taxDeviceMachineNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceType, taxDeviceType, taxDeviceMachineNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTaxDeviceQueryRequestInfo {\n");
    
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    taxDeviceType: ").append(toIndentedString(taxDeviceType)).append("\n");
    sb.append("    taxDeviceMachineNo: ").append(toIndentedString(taxDeviceMachineNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
