package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel("查询门店列表请求")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class QueryStoreListRequest {
    @ApiModelProperty("分页信息")
    private Page page;
    @ApiModelProperty("门店名称")
    private String storeName;
    @ApiModelProperty("公司id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long companyId;
    @ApiModelProperty("组织类型")
    private Integer orgType;
}
