package com.xforceplus.seller.config.client.model;

import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel("门店信息")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TaxInvoiceQuotaInfoModel implements Serializable {

    /**
     * 税号
     * 表 : tax_invoice_quota_info
     * 对应字段 : tax_no
     */
    private String taxNo;

    /**
     * 发票类型
     * 表 : tax_invoice_quota_info
     * 对应字段 : invoice_type
     */
    private String invoiceType;

    /**
     * 限额
     * 表 : tax_invoice_quota_info
     * 对应字段 : quota
     */
    private BigDecimal quota;

    /**
     * 创建时间
     * 表 : tax_invoice_quota_info
     * 对应字段 : created_at
     */
    private Date createdAt;

    /**
     * 税件最新刷新时间
     * 表 : tax_invoice_quota_info
     * 对应字段 : refreshed_at
     */
    private Date refreshedAt;

    /**
     * 更新时间
     * 表 : tax_invoice_quota_info
     * 对应字段 : modified_at
     */
    private Date modifiedAt;


}