package com.xforceplus.seller.config.client.model;

import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
@ApiModel("门店信息")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TaxQuotaInfoModel implements Serializable {
    /**
     * 租户ID
     * 表 : tax_quota_info
     * 对应字段 : tenant_id
     */
    private Long tenantId;

    /**
     * 租户CODE
     * 表 : tax_quota_info
     * 对应字段 : tenant_code
     */
    private String tenantCode;

    /**
     * 税号
     * 表 : tax_quota_info
     * 对应字段 : tax_no
     */
    private String taxNo;

    /**
     * 纸普限额
     * 表 : tax_quota_info
     * 对应字段 : c_quota
     */
    private BigDecimal cQuota;

    /**
     * 电普限额
     * 表 : tax_quota_info
     * 对应字段 : ce_quota
     */
    private BigDecimal ceQuota;

    /**
     * 纸专限额
     * 表 : tax_quota_info
     * 对应字段 : s_quota
     */
    private BigDecimal sQuota;

    /**
     * 电专限额
     * 表 : tax_quota_info
     * 对应字段 : se_quota
     */
    private BigDecimal seQuota;

    /**
     * 机动车票限额
     * 表 : tax_quota_info
     * 对应字段 : v_quota
     */
    private BigDecimal vQuota;

    /**
     * 二手机动车限额
     * 表 : tax_quota_info
     * 对应字段 : vs_quota
     */
    private BigDecimal vsQuota;

    /**
     * 卷票限额
     * 表 : tax_quota_info
     * 对应字段 : ju_quota
     */
    private BigDecimal juQuota;

    /**
     * 创建时间
     * 表 : tax_quota_info
     * 对应字段 : created_at
     */
    private Date createdAt;

    /**
     * 税件最新刷新时间
     * 表 : tax_quota_info
     * 对应字段 : refreshed_at
     */
    private Date refreshedAt;

    /**
     * 更新时间
     * 表 : tax_quota_info
     * 对应字段 : modified_at
     */
    private Date modifiedAt;


}