package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class UserRelationData {
    @ApiModelProperty("人员和开票人关系List")
    @JsonProperty("userInfoRelationList")
    private List<UserRelationInfo> userInfoRelationList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class UserRelationRequest {

        @ApiModelProperty("用户Id")
        @JsonProperty("userId")
        private Long userId;

        @ApiModelProperty("关系类型 0-人员开票人 1-人员设备？")
        @JsonProperty("relationType")
        private Integer relationType;

        @ApiModelProperty("人员所属税号集合")
        @JsonProperty("taxNoList")
        private List<String> taxNoList;

        @ApiModelProperty("开票人")
        @JsonProperty("issuer")
        private String issuer;

        @ApiModelProperty("税号权限过滤 true-过滤 默认值 false-不过滤")
        @JsonProperty("needPermission")
        private Boolean needPermission = true;

        @ApiModelProperty("当前页,从1开始")
        @JsonProperty("pageIndex")
        private Integer pageIndex;

        @ApiModelProperty("每页数量，默认不传为20条")
        @JsonProperty("pageSize")
        private Integer pageSize;
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class UserRelationInfo implements Serializable {
        @ApiModelProperty("主键id")
        @JsonProperty("id")
        private Long id;

        @ApiModelProperty("手机号码")
        @JsonProperty("mobile")
        private String mobile;

        @ApiModelProperty("邮箱")
        @JsonProperty("email")
        private String email;

        @ApiModelProperty("用户Id")
        @JsonProperty("userId")
        private Long userId;

        @ApiModelProperty("用户名称")
        @JsonProperty("userName")
        private String userName;

        @ApiModelProperty("其它/域账号名")
        @JsonProperty("accountName")
        private String accountName;

        @ApiModelProperty("用户所属租户id")
        @JsonProperty("tenantId")
        private Long tenantId;

        @ApiModelProperty("用户所属税号")
        @JsonProperty("taxNo")
        private String taxNo;

        @ApiModelProperty("关系类型")
        @JsonProperty("relationType")
        private Integer relationType;

        @ApiModelProperty("状态 0-无效 1-有效")
        @JsonProperty("status")
        private int status;

        @ApiModelProperty("开票人")
        @JsonProperty("issuer")
        private String issuer;

        @ApiModelProperty("数电开票方式")
        @JsonProperty("issueType")
        private String issueType;

        @ApiModelProperty("开票人所属公司名称")
        @JsonProperty("companyName")
        private String companyName;

        @ApiModelProperty("开票人记录主键")
        @JsonProperty("uniqueKey")
        private String uniqueKey;
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class UserRelationErrorInfo extends UserRelationInfo implements Serializable {
        @ApiModelProperty("错误原因")
        @JsonProperty("errorMsg")
        private String errorMsg;
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ImportUserRelationInfo implements Serializable {
        @ApiModelProperty("唯一主键")
        @JsonProperty("id")
        private Long id;

        @ApiModelProperty("状态 0-无效-解绑 1-有效-绑定")
        @JsonProperty("status")
        private Integer status;

        @ApiModelProperty("关系类型 0-开票人 1-设备（暂不支持）")
        @JsonProperty("relationType")
        private Integer relationType;

        @ApiModelProperty("账号-(可以是手机账号、邮箱账号、其他账号）")
        @JsonProperty("accountName")
        private String accountName;

        @ApiModelProperty("用户和开票人所属税号")
        @JsonProperty("taxNo")
        private String taxNo;

        @ApiModelProperty("数电开票方式：电子税务局 或 乐企")
        @JsonProperty("issueType")
        private String issueType;

        @ApiModelProperty("开票人")
        @JsonProperty("issuer")
        private String issuer;
    }


    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class UpdateUserRelationRequest {
        @ApiModelProperty("开票人")
        @JsonProperty("issuer")
        private String issuer;

        @ApiModelProperty("启用状态： 1-启用、 0-停用")
        @JsonProperty("status")
        private Integer status;

        @ApiModelProperty("记录唯一主键")
        @JsonProperty("uniqueKey")
        private String uniqueKey;
    }


}
