package com.xforceplus.seller.config.client.parse.bean;

import com.xforceplus.seller.config.client.constant.PriceMethodTypeEnum;
import com.xforceplus.seller.config.client.parse.BaseRuleBean;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author zzw
 * @Description 发票拆分规则DTO 返回给其他应用或微服务
 * @Date
 * @return
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class InvoiceSplitrRuleDTO extends BaseRuleBean {
    @ApiModelProperty("拆票限额")
    private BigDecimal invoiceLimit;
    @ApiModelProperty("价格方式：0-不含税 1-含税")
    private PriceMethodTypeEnum priceMethod;
    @ApiModelProperty("可拆票字段")
    private List<String> splitFiledList  = new ArrayList<>();
    @ApiModelProperty("智能拆分表示 0-拆票时不合并 1-拆票时合并")
    private boolean mergeBySplitField =  Boolean.FALSE;
    @ApiModelProperty("拆票折扣率 0-100 为百分比值")
    private BigDecimal discountRateLimit = BigDecimal.valueOf(100);
    @ApiModelProperty("设备类型")
    private String taxDeviceType;
    @ApiModelProperty("明细顺序")
    private String itemSort;
    @ApiModelProperty("销货清单最大行数")
    private Integer salesListMaxRow;
    @ApiModelProperty("单价数量选项")
    private String unitPriceAmountOps;
    @ApiModelProperty("金额拆分规则")
    private String amountSplitRule;
    @ApiModelProperty("是否支持整形")
    private boolean integerOps = Boolean.FALSE;
    @ApiModelProperty("发票票面明细最大数")
    private Integer invoiceItemMaxRow;
    @ApiModelProperty("发票备注字段列表")
    private List<String> invoiceRemarkFiledList  = new ArrayList<>();
    @ApiModelProperty("折扣模式")
    private String discountMode;
    @ApiModelProperty("销货清单选项")
    private String saleListOption;
    @ApiModelProperty("发票规格")
    private String invoiceSpec;
    @ApiModelProperty("发票类型")
    private String invoiceType;
    @ApiModelProperty("货物或应税劳务、服务名称字段")
    private List<String> goodsServicesNameFieldsList;
    @ApiModelProperty("规格型号")
    private List<String> itemSpecFieldsList;

    @ApiModelProperty("货物或应税劳务、服务名称字段")
    private List<String> goodsServicesNameMainFieldsList;

    @ApiModelProperty("规格型号")
    private List<String> itemSpecMainFieldsList;

    @ApiModelProperty("业务单折扣率")
    private BigDecimal bizBillDiscountRate = new BigDecimal("1");
    @ApiModelProperty("税额最大容差")
    private BigDecimal taxAmountAllowMax;

    @ApiModelProperty("自定义备注长度 默认168，电票默认130")
    @Min(
            value = 1L,
            message = "长度限制最小为1"
    )
    private Integer customRemarkSize;


    @ApiModelProperty("拆票策略,优先出票 0（默认）,优先规则 1")
    private String ruleStrategy;
    @ApiModelProperty("单价位数")
    private Integer priceScale;

    @ApiModelProperty("国税发票来源")
    private String taxInvoiceSource;


    @ApiModelProperty("备注字段值是否去重, 否 0,是 1（默认）")
    private boolean remarkDuplicateFlag = Boolean.TRUE;

    @ApiModelProperty("备注字段是否隐藏字段名")
    private String hideRemarkFieldName = "false";

    @ApiModelProperty("是否打印规格型号")
    private String printItemSpecFlag = "true";

    @ApiModelProperty("是否价外折扣转价内折扣")
    private String outerToInnerDiscount = "false";

    @ApiModelProperty("备注字段名和字段值分隔符")
    private Integer remarkKeyValueShowType =null;

    @ApiModelProperty("数量限额")
    private BigDecimal quantityLimit;

    @ApiModelProperty("使用数量限额的单位")
    private String quantityLimitUnit;

    /*
    public String getOuterToInnerDiscount() {
        return outerToInnerDiscount;
    }

    public void setOuterToInnerDiscount(String outerToInnerDiscount) {
        this.outerToInnerDiscount = outerToInnerDiscount;
    }

    public String getPrintItemSpecFlag() {
        return printItemSpecFlag;
    }

    public void setPrintItemSpecFlag(String printItemSpecFlag) {
        this.printItemSpecFlag = printItemSpecFlag;
    }

    public String getHideRemarkFieldName() {
        return hideRemarkFieldName;
    }

    public void setHideRemarkFieldName(String hideRemarkFieldName) {
        this.hideRemarkFieldName = hideRemarkFieldName;
    }

    public String getTaxInvoiceSource() {
        return taxInvoiceSource;
    }

    public void setTaxInvoiceSource(String taxInvoiceSource) {
        this.taxInvoiceSource = taxInvoiceSource;
    }

    public boolean isRemarkDuplicateFlag() {
        return remarkDuplicateFlag;
    }

    public void setRemarkDuplicateFlag(boolean remarkDuplicateFlag) {
        this.remarkDuplicateFlag = remarkDuplicateFlag;
    }

    public String getRuleStrategy() {
        return ruleStrategy;
    }

    public void setRuleStrategy(String ruleStrategy) {
        this.ruleStrategy = ruleStrategy;
    }

    public Integer getPriceScale() {
        return priceScale;
    }

    public void setPriceScale(Integer priceScale) {
        this.priceScale = priceScale;
    }

    */
    /**
     * 添加主信息和明细备注区别，原来的备注直接当主信息用
     * @return
     */
    @ApiModelProperty("明细发票备注字段列表")
    private List<String> invoiceItemRemarkFiledList  = new ArrayList<>();
    /*

    public BigDecimal getBizBillDiscountRate() {
        return bizBillDiscountRate;
    }

    public void setBizBillDiscountRate(BigDecimal bizBillDiscountRate) {
        this.bizBillDiscountRate = bizBillDiscountRate;
    }

    public PriceMethodTypeEnum getPriceMethod() {
        return priceMethod;
    }

    public void setPriceMethod(PriceMethodTypeEnum priceMethod) {
        this.priceMethod = priceMethod;
    }

    public BigDecimal getInvoiceLimit() {
        return invoiceLimit;
    }

    public void setInvoiceLimit(BigDecimal invoiceLimit) {
        this.invoiceLimit = invoiceLimit;
    }

    public List<String> getSplitFiledList() {
        return splitFiledList;
    }

    public void setSplitFiledList(List<String> splitFiledList) {
        this.splitFiledList = splitFiledList;
    }

    public boolean getMergeBySplitField() {
        return mergeBySplitField;
    }

    public void setMergeBySplitField(boolean mergeBySplitField) {
        this.mergeBySplitField = mergeBySplitField;
    }

    public BigDecimal getDiscountRateLimit() {
        return discountRateLimit;
    }

    public void setDiscountRateLimit(BigDecimal discountRateLimit) {
        this.discountRateLimit = discountRateLimit;
    }


    public String getTaxDeviceType() {
        return taxDeviceType;
    }

    public void setTaxDeviceType(String taxDeviceType) {
        this.taxDeviceType = taxDeviceType;
    }

    public String getItemSort() {
        return itemSort;
    }

    public void setItemSort(String itemSort) {
        this.itemSort = itemSort;
    }

    public Integer getSalesListMaxRow() {
        return salesListMaxRow;
    }

    public void setSalesListMaxRow(Integer salesListMaxRow) {
        this.salesListMaxRow = salesListMaxRow;
    }

    public String getUnitPriceAmountOps() {
        return unitPriceAmountOps;
    }

    public void setUnitPriceAmountOps(String unitPriceAmountOps) {
        this.unitPriceAmountOps = unitPriceAmountOps;
    }

    public String getAmountSplitRule() {
        return amountSplitRule;
    }

    public void setAmountSplitRule(String amountSplitRule) {
        this.amountSplitRule = amountSplitRule;
    }

    public boolean isIntegerOps() {
        return integerOps;
    }

    public void setIntegerOps(boolean integerOps) {
        this.integerOps = integerOps;
    }

    public Integer getInvoiceItemMaxRow() {
        return invoiceItemMaxRow;
    }

    public void setInvoiceItemMaxRow(Integer invoiceItemMaxRow) {
        this.invoiceItemMaxRow = invoiceItemMaxRow;
    }

    public List<String> getInvoiceRemarkFiledList() {
        return invoiceRemarkFiledList;
    }

    public void setInvoiceRemarkFiledList(List<String> invoiceRemarkFiledList) {
        this.invoiceRemarkFiledList = invoiceRemarkFiledList;
    }

    public String getDiscountMode() {
        return discountMode;
    }

    public void setDiscountMode(String discountMode) {
        this.discountMode = discountMode;
    }

    public String getSaleListOption() {
        return saleListOption;
    }

    public void setSaleListOption(String saleListOption) {
        this.saleListOption = saleListOption;
    }

    public String getInvoiceSpec() {
        return invoiceSpec;
    }

    public void setInvoiceSpec(String invoiceSpec) {
        this.invoiceSpec = invoiceSpec;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public List<String> getInvoiceItemRemarkFiledList() {
        return invoiceItemRemarkFiledList;
    }

    public void setInvoiceItemRemarkFiledList(List<String> invoiceItemRemarkFiledList) {
        this.invoiceItemRemarkFiledList = invoiceItemRemarkFiledList;
    }

    public List<String> getGoodsServicesNameFieldsList() {
        return goodsServicesNameFieldsList;
    }

    public void setGoodsServicesNameFieldsList(List<String> goodsServicesNameFieldsList) {
        this.goodsServicesNameFieldsList = goodsServicesNameFieldsList;
    }

    public List<String> getItemSpecFieldsList() {
        return itemSpecFieldsList;
    }

    public void setItemSpecFieldsList(List<String> itemSpecFieldsList) {
        this.itemSpecFieldsList = itemSpecFieldsList;
    }

    public List<String> getGoodsServicesNameMainFieldsList() {
        return goodsServicesNameMainFieldsList;
    }

    public void setGoodsServicesNameMainFieldsList(List<String> goodsServicesNameMainFieldsList) {
        this.goodsServicesNameMainFieldsList = goodsServicesNameMainFieldsList;
    }

    public List<String> getItemSpecMainFieldsList() {
        return itemSpecMainFieldsList;
    }

    public void setItemSpecMainFieldsList(List<String> itemSpecMainFieldsList) {
        this.itemSpecMainFieldsList = itemSpecMainFieldsList;
    }

    public Integer getCustomRemarkSize() {
        return customRemarkSize;
    }

    public void setCustomRemarkSize(Integer customRemarkSize) {
        this.customRemarkSize = customRemarkSize;
    }

    public BigDecimal getTaxAmountAllowMax() {
        return taxAmountAllowMax;
    }

    public void setTaxAmountAllowMax(BigDecimal taxAmountAllowMax) {
        this.taxAmountAllowMax = taxAmountAllowMax;
    }

    public Integer getRemarkKeyValueShowType() {
        return remarkKeyValueShowType;
    }

    public void setRemarkKeyValueShowType(Integer remarkKeyValueShowType) {
        this.remarkKeyValueShowType = remarkKeyValueShowType;
    }

    @Override
    public String toString() {
        return "InvoiceSplitrRuleDTO{" +
                "invoiceLimit=" + invoiceLimit +
                ", priceMethod=" + priceMethod +
                ", splitFiledList=" + splitFiledList +
                ", mergeBySplitField=" + mergeBySplitField +
                ", discountRateLimit=" + discountRateLimit +
                ", taxDeviceType='" + taxDeviceType + '\'' +
                ", itemSort='" + itemSort + '\'' +
                ", salesListMaxRow=" + salesListMaxRow +
                ", unitPriceAmountOps='" + unitPriceAmountOps + '\'' +
                ", amountSplitRule='" + amountSplitRule + '\'' +
                ", integerOps=" + integerOps +
                ", invoiceItemMaxRow=" + invoiceItemMaxRow +
                ", invoiceRemarkFiledList=" + invoiceRemarkFiledList +
                ", discountMode='" + discountMode + '\'' +
                ", saleListOption='" + saleListOption + '\'' +
                ", invoiceSpec='" + invoiceSpec + '\'' +
                ", invoiceType='" + invoiceType + '\'' +
                ", goodsServicesNameFieldsList=" + goodsServicesNameFieldsList +
                ", itemSpecFieldsList=" + itemSpecFieldsList +
                ", goodsServicesNameMainFieldsList=" + goodsServicesNameMainFieldsList +
                ", itemSpecMainFieldsList=" + itemSpecMainFieldsList +
                ", bizBillDiscountRate=" + bizBillDiscountRate +
                ", customRemarkSize=" + customRemarkSize +
                ", ruleStrategy='" + ruleStrategy + '\'' +
                ", priceScale=" + priceScale +
                ", remarkDuplicateFlag=" + remarkDuplicateFlag +
                ", invoiceItemRemarkFiledList=" + invoiceItemRemarkFiledList +
                ", taxAmountAllowMax=" + taxAmountAllowMax +
                '}';
    }
    */
}
