package com.xforceplus.seller.config.client.parse.bean;


import com.xforceplus.seller.config.client.constant.redconfirmmatch.MainMatchField;
import com.xforceplus.seller.config.client.constant.redconfirmmatch.MatchOp;
import com.xforceplus.seller.config.client.parse.BaseRuleBean;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Data
public class RedConfirmMatchRuleDTO  extends BaseRuleBean  {
    private String matchRule;
    private String matchCalRule;
    private String matchDiff;
    private String matchItemDiff;
    private String unitPriceDiff;
    private List<String> matchCondition;
    @ApiModelProperty("税额匹配容差")
    private String taxAmountDiff;
    @ApiModelProperty("主信息匹配策略")
    private List<MainMatchCondition> mainMatchStrategy;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class MainMatchCondition {
        private MainMatchField field;
        private MatchOp op;
        private String type;
        @ApiModelProperty("op为eq、not_eq、like、gt、lt时有值")
        private String value;
        @ApiModelProperty("op为in、range时有值")
        private List<String> valueList;
        @ApiModelProperty("时间配置模式。仅时间类型字段支持，")
        private Integer timeMode;
    }
}
