package com.xforceplus.seller.config.client.parse.bean;

import com.xforceplus.seller.config.client.constant.redconfirmmatch.MatchOp;
import com.xforceplus.seller.config.client.constant.smartmatch.SmartMatchField;
import com.xforceplus.seller.config.client.parse.BaseRuleBean;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
public class SmartMatchRuleDTO extends BaseRuleBean {
    @ApiModelProperty("找票规则")
    private List<FindRuleItem> findRule;
    @ApiModelProperty("打分规则")
    private List<CalScoreRuleItem> calScoreRule;
    @ApiModelProperty("默认红冲原因")
    private String redReason;
    @ApiModelProperty("匹配算法, 0-时间最近 1-时间最远")
    private Integer matchAlgorithm;
    @ApiModelProperty("金额校验规则")
    private Integer amountCheckRule;
    @ApiModelProperty("税额适配范围")
    private BigDecimal taxAmountMaxAdjust;
    @ApiModelProperty("找票方式")
    private Integer findAlgorithm;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class FindRuleItem {
        private SmartMatchField field;
        @ApiModelProperty("操作符")
        private MatchOp op;
        @ApiModelProperty("字段类型")
        private String type;
        private String value;
        private List<String> valueList;
        @ApiModelProperty("时间配置模式。仅时间类型字段支持，")
        private Integer timeMode;
        private Integer fieldKind;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class CalScoreRuleItem {
        private SmartMatchField field;
        @ApiModelProperty("字段类型")
        private String type;
        @ApiModelProperty("匹配类型")
        private String matchType;
        @ApiModelProperty("容差，仅当type为BigDecimal时有效")
        private BigDecimal tolerance;
        @ApiModelProperty("是否要求强一致，强一致也遵循容差配置")
        private Boolean force;
        @ApiModelProperty("值类型，当type为String或BigDecimal时有效")
        private Integer valueMode;
        @ApiModelProperty("值，当valueModel为1时有效")
        private String value;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class SmartMatchCondition {
        //findRuleItem用
        private SmartMatchField field;
        @ApiModelProperty("操作符")
        private MatchOp op;
        @ApiModelProperty("字段类型")
        private String type;
        private String value;
        private List<String> valueList;
        @ApiModelProperty("时间配置模式。仅时间类型字段支持，")
        private Integer timeMode;
        //calScoreRuleItem用
        @ApiModelProperty("容差，仅当type为BigDecimal时有效")
        private BigDecimal tolerance;
        @ApiModelProperty("是否要求强一致，强一致也遵循容差配置")
        private Boolean force;
        @ApiModelProperty("值类型，当type为String或BigDecimal时有效")
        private Integer valueMode;
    }
}
