package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.constant.MergeRuleEnum;
import com.xforceplus.seller.config.client.constant.NagertiveRuleEnum;
import com.xforceplus.seller.config.client.constant.SecondMergeRuleEnum;
import com.xforceplus.seller.config.client.model.CombinationFieldBean;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.BillMergerRuleDTO;
import com.xforceplus.xplatframework.utils.JsonUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author zzw
 * @Description
 * @Date
 * @return
 **/
@Component
public class BillMergeParser implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(BillMergeParser.class);

    @Override
    public BillMergerRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        if (CollectionUtils.isEmpty(cfgConfigItemEntities)) {
            return null;
        }
        BillMergerRuleDTO billMergerRuleDTO = new BillMergerRuleDTO();
        for (MsConfigItemBean msConfigItemBean : cfgConfigItemEntities) {
            billMergerRuleDTO.setRuldId(msConfigItemBean.getConfigId());
            String fieldName = msConfigItemBean.getConfigItemName();
            if (StringUtils.isEmpty(fieldName)) {
                continue;
            }
            List<String> itemValueList = msConfigItemBean.getConfigItemValue();
            if (CollectionUtils.isEmpty(itemValueList)){
                logger.info("BillMergeParser--itemValueList--parse--Merge配置项值设置错误:null");
                itemValueList = Lists.newArrayList("");
            }
            String itemValue = itemValueList.get(0);
            //自动组合
            if ("autoAssociationFlag".equals(fieldName)) {
                  billMergerRuleDTO.setAutoAssociationFlag(itemValue);
            }
            //自动合并
            else if ("autoMergeFlag".equals(fieldName)) {
                 billMergerRuleDTO.setAutoMergeFlag(Boolean.parseBoolean(itemValue));
            }else if ("secondMergeFlag".equals(fieldName)){
                if (CommonTools.isEmpty(fieldName)){
                    billMergerRuleDTO.setSecondMergeFlag(false);
                }else {
                    billMergerRuleDTO.setSecondMergeFlag(Boolean.parseBoolean(itemValue));
                }

            }
            //组合条件
            else if ("associationCondition".equals(fieldName)
                    ||"defaultAssociationCondition".equals(fieldName)
                    ||"associationConditionItem".equals(fieldName)
                    ) {
                StringBuilder sb = new StringBuilder();
                if(itemValueList.size()>0){
                    sb.append("[");
                    itemValueList.forEach(m->{
                        sb.append(m);
                        sb.append(",");
                    });
                    sb.append("]");
                    String itemlistJson = sb.toString().replace(",]","]");

                    List<CombinationFieldBean> combinationFieldBeanList = JsonUtils.writeJsonToListObject(itemlistJson, CombinationFieldBean.class);
                    if(billMergerRuleDTO.getAssociationCondition()==null){
                        billMergerRuleDTO.setAssociationCondition(combinationFieldBeanList);
                    }else {
                        billMergerRuleDTO.getAssociationCondition().addAll(combinationFieldBeanList);
                    }
                }

            }
            //组合条件
            else if ("mergerCondition".equals(fieldName)
                    ||"defaultMergerCondition".equals(fieldName)
                    ||"mergerConditionItem".equals(fieldName)) {
                StringBuilder sb = new StringBuilder();
                if(itemValueList.size()>0) {
                    sb.append("[");
                    itemValueList.forEach(m -> {
                        sb.append(m);
                        sb.append(",");
                    });
                    sb.append("]");
                    //bugfix-5343, 数据库中空格会影响转换
                    String itemlistJson = sb.toString().replace(",]", "]").replace(" ", "");
                    List<CombinationFieldBean> combinationFieldBeanList = JsonUtils.writeJsonToListObject(itemlistJson, CombinationFieldBean.class);
                    if (billMergerRuleDTO.getMergerCondition() == null) {
                        billMergerRuleDTO.setMergerCondition(combinationFieldBeanList);
                    } else {
                        billMergerRuleDTO.getMergerCondition().addAll(combinationFieldBeanList);
                    }
                }
            } else if ("secondMergeCondition".equals(fieldName)
                    ||"defaultSecondMergeCondition".equals(fieldName)
                    ||"secondMergeConditionItem".equals(fieldName)) {
                StringBuilder sb = new StringBuilder();
                if(itemValueList.size()>0) {
                    sb.append("[");
                    itemValueList.forEach(m -> {
                        sb.append(m);
                        sb.append(",");
                    });
                    sb.append("]");
                    //bugfix-5343, 数据库中空格会影响转换
                    String itemlistJson = sb.toString().replace(",]", "]").replace(" ", "");
                    List<CombinationFieldBean> combinationFieldBeanList = JsonUtils.writeJsonToListObject(itemlistJson, CombinationFieldBean.class);
                    if (billMergerRuleDTO.getSecondMergeCondition() == null) {
                        billMergerRuleDTO.setSecondMergeCondition(combinationFieldBeanList);
                    } else {
                        billMergerRuleDTO.getSecondMergeCondition().addAll(combinationFieldBeanList);
                    }
                }
            }
            //合并规则 数量合并为1 ，保留单价  无数量无单价
            else if ("mergeRule".equals(fieldName)) {
                 billMergerRuleDTO.setMergeRule(MergeRuleEnum.getvalueByValue(Integer.parseInt(itemValue)));
            }
            //正负合并
            else if ("nagertiveRule".equals(fieldName)) {
                billMergerRuleDTO.setNagertiveRule(NagertiveRuleEnum.getvalueByValue(Integer.parseInt(itemValue)));
            }//二次正负合并
            else if ("secondNagertiveRule".equals(fieldName)) {
                if (CommonTools.isEmpty(itemValue)){
                    continue;
                }
                billMergerRuleDTO.setSecondNagertiveRule(SecondMergeRuleEnum.getvalueByValue(Integer.parseInt(itemValue)));
            }else if ("secondMergeRule".equals(fieldName)) {
                if (CommonTools.isEmpty(itemValue)){
                    itemValue = "4";
                }
                billMergerRuleDTO.setSecondMergeRule(MergeRuleEnum.getvalueByValue(Integer.parseInt(itemValue)));
            }else if ("invoiceLimit".equals(fieldName)){
                billMergerRuleDTO.setInvoiceLimit(itemValue);
            }else if ("extStr".equals(fieldName)){
                billMergerRuleDTO.setExtStr(itemValue);
            }else if("commonInvoiceTypeBound".equals(fieldName)){
                billMergerRuleDTO.setCommonInvoiceTypeBound(itemValue);
            }else if("commonElectronicInvoiceTypeBound".equals(fieldName)){
                billMergerRuleDTO.setCommonElectronicInvoiceTypeBound(itemValue);
            }else if("specialInvoiceTypeBound".equals(fieldName)){
                billMergerRuleDTO.setSpecialInvoiceTypeBound(itemValue);
            }else if("specialElectronicInvoiceTypeBound".equals(fieldName)){
                billMergerRuleDTO.setSpecialElectronicInvoiceTypeBound(itemValue);
            } else if ("presentMergeFlag".equals(fieldName)) {
                billMergerRuleDTO.setPresentMergeFlag(Boolean.parseBoolean(itemValue));
            } else if ("remarkJoinLimitFlag".equals(fieldName)) {
                billMergerRuleDTO.setRemarkJoinLimitFlag(Boolean.parseBoolean(itemValue));
            } else if ("enableAccAmountConsistent".equals(fieldName)) {
                billMergerRuleDTO.setEnableAccAmountConsistent(Boolean.parseBoolean(itemValue));
            }
        }
        return billMergerRuleDTO;
    }

}

