/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.constant;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.EnumUtils;

public enum ConfigTypeEnum {
    SPLIT_CONFIG_TYPE(1, "\u62c6\u7968\u89c4\u5219", "invoiceSplitConfig"),
    MERGE_CONFIG_TYPE(2, "\u62c6\u5408\u89c4\u5219", "billMergeSplitConfig"),
    INVOICE_CONFIG_TYPE(3, "\u7968\u9762\u4fe1\u606f\u89c4\u5219", "invoiceInfoConfig"),
    INVOICE_USER_CONFIG_TYPE(4, "\u7968\u9762\u4eba\u5458\u89c4\u5219", "invoiceMemberInfoConfig"),
    PROCESS_CONFIG_TYPE(5, "\u4e1a\u52a1\u6d41\u7a0b\u89c4\u5219", "pageProcssConfig"),
    SYS_CONFIG_TYPE(6, "\u7cfb\u7edf\u89c4\u5219", "sysConfig"),
    BILL_MERGE_TYPE(7, "\u7ec4\u5408\u5408\u5e76\u89c4\u5219", "mergeRule"),
    BILL_INVOICE_MATCH_TYPE(8, "\u53d1\u7968\u5339\u914d\u4e1a\u52a1\u5355", "invoiceMatchConfig"),
    VIRTUAL_INVOICE_AUTO_RULE_TYPE(9, "\u81ea\u52a8\u5f00\u7968\u7ea2\u51b2\u89c4\u5219", "virtualInvoiceAutoRule"),
    INVOICE_MAIL_RULE_CONFIG_TYPE(10, "\u53d1\u7968\u90ae\u4ef6\u63a8\u9001\u89c4\u5219", "invoiceMailRuleConfig"),
    INVOICE_OPERRATIOON_CONFIG_TYPE(11, "\u53d1\u7968\u7ea2\u51b2\u4f5c\u5e9f\u539f\u56e0\u89c4\u5219", "invoiceOperationConfig"),
    UNKNOWN(0, "\u672a\u77e5\u89c4\u5219", "unknown"),
    MULTI_INVOICE_TITLE_CONFIG_TYPE(12, "\u62ac\u5934\u4fe1\u606f\u89c4\u5219", "invoiceTitleConfig"),
    ORDER_SEARCH_CONFIG_TYPE(13, "\u8ba2\u5355\u641c\u7d22\u6761\u4ef6\u914d\u7f6e", "orderSearchConfig"),
    H5_SYS_CONFIG_TYPE(14, "H5\u89c4\u5219\u914d\u7f6e", "h5SystermConfig"),
    DISCOUNT_RATE_CONFIG_TYPE(15, "\u6298\u6263\u7387\u89c4\u5219\u914d\u7f6e", "discountRateConfig"),
    RED_CONFIRM_MATCH_CONFIG_TYPE(16, "\u7ea2\u5b57\u786e\u8ba4\u5355\u914d\u7f6e", "redConfirmMatchConfig"),
    FIRST_INVOICER(17, "\u4f18\u5148\u5f00\u7968\u4eba\u914d\u7f6e", "firstInvoicer"),
    PURCHASE_RESALE_TYPE(18, "\u8fdb\u8f6c\u9500\u89c4\u5219", "purchaseResaleType"),
    SMART_MATCH_CONFIG_TYPE(19, "\u667a\u80fd\u63a8\u8350\u89c4\u5219", "smartMatchConfig"),
    DISCONNECT_NOTICE_CONFIG_TYPE(20, "\u6389\u7ebf\u901a\u77e5\u89c4\u5219", "disconnectNoticeConfig"),
    ISSUE_VALIDATE_CONFIG_TYPE(21, "\u5f00\u7968\u6821\u9a8c\u89c4\u5219", "issueValidateConfig"),
    INVOICE_FIELD_CONVERT_CONFIG_TYPE(22, "\u7968\u9762\u8f6c\u6362\u89c4\u5219", "invoiceFieldConvertConfig"),
    INVOICE_RISK_CONTROL_CONFIG_TYPE(23, "\u5f00\u7968\u98ce\u63a7\u89c4\u5219", "invoiceFieldConvertConfig");

    private final Integer configType;
    private final String configTypeDesc;
    private final String objCode;

    public static ConfigTypeEnum of(Integer configType) {
        if (configType == null) {
            return UNKNOWN;
        }
        return Stream.of(ConfigTypeEnum.values()).filter(c -> Objects.equals(c.configType, configType)).findFirst().orElse(UNKNOWN);
    }

    public static ConfigTypeEnum getConfigTypeByValue(Integer configType) {
        ConfigTypeEnum[] configTypeEnums;
        for (ConfigTypeEnum tmp : configTypeEnums = ConfigTypeEnum.values()) {
            if (!tmp.getConfigType().equals(configType)) continue;
            return tmp;
        }
        return null;
    }

    public static Optional<ConfigTypeEnum> getConfigTypeByObjCode(String objCode) {
        return EnumUtils.getEnumList(ConfigTypeEnum.class).stream().filter(r -> r.getObjCode().equals(objCode)).findFirst();
    }

    private ConfigTypeEnum(Integer configType, String configTypeDesc, String objCode) {
        this.configType = configType;
        this.configTypeDesc = configTypeDesc;
        this.objCode = objCode;
    }

    public Integer getConfigType() {
        return this.configType;
    }

    public String getConfigTypeDesc() {
        return this.configTypeDesc;
    }

    public String getObjCode() {
        return this.objCode;
    }
}

