/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.constant.smartmatch;

import com.google.common.collect.Lists;
import com.xforceplus.seller.config.client.constant.ValueEnum;
import com.xforceplus.seller.config.client.constant.redconfirmmatch.MainMatchFieldType;
import com.xforceplus.seller.config.client.constant.redconfirmmatch.MatchTimeMode;
import com.xforceplus.seller.config.client.constant.smartmatch.SmartMatchFieldKind;
import com.xforceplus.seller.config.client.constant.smartmatch.SmartMatchFieldUseKind;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public enum SmartMatchField implements ValueEnum<String>
{
    identifyStatus("identifyStatus", "\u52fe\u9009\u72b6\u6001", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    authTaxPeriod("authTaxPeriod", "\u589e\u503c\u7a0e\u4f7f\u7528\u6240\u5c5e\u671f", MainMatchFieldType.Month, Lists.newArrayList((Object[])new Integer[]{24, 0}), "yyyyMM", SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    paperDrawDate("paperDrawDate", "\u84dd\u7968\u5f00\u7968\u65e5\u671f", MainMatchFieldType.Timestamp, Lists.newArrayList((Object[])new Integer[]{732, 0}), null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    reversedRatio("reversedRatio", "\u660e\u7ec6\u7ea2\u51b2\u6bd4\u4f8b", MainMatchFieldType.Decimal, null, null, SmartMatchFieldKind.ITEM, SmartMatchFieldUseKind.SCORE),
    itemCode("itemCode", "\u8d27\u7269\u53ca\u670d\u52a1\u4ee3\u7801", MainMatchFieldType.String, null, null, SmartMatchFieldKind.ITEM, SmartMatchFieldUseKind.SCORE),
    itemName("itemName", "\u8d27\u7269\u53ca\u670d\u52a1\u540d\u79f0", MainMatchFieldType.String, null, null, SmartMatchFieldKind.ITEM, SmartMatchFieldUseKind.SCORE),
    goodsTaxNo("goodsTaxNo", "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", MainMatchFieldType.String, null, null, SmartMatchFieldKind.ITEM, SmartMatchFieldUseKind.SCORE),
    itemSpec("itemSpec", "\u89c4\u683c\u578b\u53f7", MainMatchFieldType.String, null, null, SmartMatchFieldKind.ITEM, SmartMatchFieldUseKind.SCORE),
    quantityUnit("quantityUnit", "\u6570\u91cf\u5355\u4f4d", MainMatchFieldType.String, null, null, SmartMatchFieldKind.ITEM, SmartMatchFieldUseKind.SCORE),
    taxRate("taxRate", "\u7a0e\u7387", MainMatchFieldType.BigDecimal, null, null, SmartMatchFieldKind.ITEM, SmartMatchFieldUseKind.SCORE),
    unitPrice("unitPrice", "\u4e0d\u542b\u7a0e\u5355\u4ef7", MainMatchFieldType.BigDecimal, null, null, SmartMatchFieldKind.ITEM, SmartMatchFieldUseKind.SCORE),
    ext1("ext1", "\u6269\u5c55\u5b57\u6bb51", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext2("ext2", "\u6269\u5c55\u5b57\u6bb52", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext3("ext3", "\u6269\u5c55\u5b57\u6bb53", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext4("ext4", "\u6269\u5c55\u5b57\u6bb54", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext5("ext5", "\u6269\u5c55\u5b57\u6bb55", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext6("ext6", "\u6269\u5c55\u5b57\u6bb56", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext7("ext7", "\u6269\u5c55\u5b57\u6bb57", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext8("ext8", "\u6269\u5c55\u5b57\u6bb58", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext9("ext9", "\u6269\u5c55\u5b57\u6bb59", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext10("ext10", "\u6269\u5c55\u5b57\u6bb510", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext11("ext11", "\u6269\u5c55\u5b57\u6bb511", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext12("ext12", "\u6269\u5c55\u5b57\u6bb512", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext13("ext13", "\u6269\u5c55\u5b57\u6bb513", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext14("ext14", "\u6269\u5c55\u5b57\u6bb514", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext15("ext15", "\u6269\u5c55\u5b57\u6bb515", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext16("ext16", "\u6269\u5c55\u5b57\u6bb516", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext17("ext17", "\u6269\u5c55\u5b57\u6bb517", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext18("ext18", "\u6269\u5c55\u5b57\u6bb518", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext19("ext19", "\u6269\u5c55\u5b57\u6bb519", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext20("ext20", "\u6269\u5c55\u5b57\u6bb520", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext21("ext21", "\u6269\u5c55\u5b57\u6bb521", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext22("ext22", "\u6269\u5c55\u5b57\u6bb522", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext23("ext23", "\u6269\u5c55\u5b57\u6bb523", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext24("ext24", "\u6269\u5c55\u5b57\u6bb524", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER),
    ext25("ext25", "\u6269\u5c55\u5b57\u6bb525", MainMatchFieldType.Enum, null, null, SmartMatchFieldKind.MAIN, SmartMatchFieldUseKind.FILTER);

    private final String value;
    private final String description;
    private final MainMatchFieldType type;
    private final List<Integer> timeRange;
    private final String monthPattern;
    private final SmartMatchFieldKind kind;
    private final SmartMatchFieldUseKind useKind;

    public static Optional<String> checkTimestampFieldTypeValue(SmartMatchField field, Integer timeMode, List<String> valueList, List<Integer> timeRange) {
        MatchTimeMode matchTimeMode = ValueEnum.getEnumByValue(MatchTimeMode.class, timeMode).orElse(null);
        if (MatchTimeMode.TIME == matchTimeMode) {
            List dateList = valueList.stream().map(r -> {
                try {
                    return new Date(Long.parseLong(r));
                }
                catch (Exception e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (dateList.size() != 2) {
                return Optional.of(String.format("\u5339\u914d\u5b57\u6bb5\uff1a%s\u7684\u65f6\u95f4\u9009\u62e9\u5668\u503c\u6709\u8bef", field.getDescription()));
            }
            if (((Date)dateList.get(0)).compareTo((Date)dateList.get(1)) > 0) {
                return Optional.of(String.format("\u5339\u914d\u5b57\u6bb5\uff1a%s\u7684\u65f6\u95f4\u9009\u62e9\u5668\u503c\u6709\u8bef", field.getDescription()));
            }
            LocalDateTime beginDate = LocalDateTime.ofInstant(((Date)dateList.get(0)).toInstant(), ZoneId.systemDefault());
            LocalDateTime endDate = LocalDateTime.ofInstant(((Date)dateList.get(1)).toInstant(), ZoneId.systemDefault());
            int maxRangeDays = timeRange.get(0) - timeRange.get(1);
            if (Duration.between(beginDate, endDate).toDays() > (long)maxRangeDays) {
                if (maxRangeDays < 365) {
                    return Optional.of(String.format("\u5339\u914d\u5b57\u6bb5\uff1a%s\u7684\u65f6\u95f4\u9009\u62e9\u5668\u503c\u8d85\u51fa\u89c4\u5b9a\u8303\u56f4\uff0c\u6700\u5927\u652f\u6301\u9009\u62e9\u8303\u56f4\u4e3a%s\u5929", field.getDescription(), maxRangeDays));
                }
                return Optional.of(String.format("\u5339\u914d\u5b57\u6bb5\uff1a%s\u7684\u65f6\u95f4\u9009\u62e9\u5668\u503c\u8d85\u51fa\u89c4\u5b9a\u8303\u56f4\uff0c\u6700\u5927\u652f\u6301\u9009\u62e9\u8303\u56f4\u4e3a%s\u5e74", field.getDescription(), maxRangeDays / 365));
            }
        } else if (MatchTimeMode.RANGE == matchTimeMode) {
            List rangeList = valueList.stream().map(r -> {
                try {
                    return Integer.parseInt(r);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (rangeList.size() != 2) {
                return Optional.of(String.format("\u5339\u914d\u5b57\u6bb5\uff1a%s\u7684\u8303\u56f4\u9009\u62e9\u5668\u503c\u6709\u8bef", field.getDescription()));
            }
            if ((Integer)rangeList.get(0) <= (Integer)rangeList.get(1)) {
                return Optional.of(String.format("\u5339\u914d\u5b57\u6bb5\uff1a%s\u7684\u8303\u56f4\u9009\u62e9\u5668\u503c\u6709\u8bef", field.getDescription()));
            }
            if ((Integer)rangeList.get(0) > timeRange.get(0) || (Integer)rangeList.get(1) < timeRange.get(1)) {
                return Optional.of(String.format("\u5339\u914d\u5b57\u6bb5\uff1a%s\u7684\u8303\u56f4\u9009\u62e9\u5668\u503c\u8d85\u51fa\u89c4\u5b9a\u8303\u56f4\uff0c\u9ed8\u8ba4\u4e3a\u4ece%s\u5230%s", field.getDescription(), timeRange.get(0), timeRange.get(1)));
            }
        } else {
            return Optional.of(String.format("\u5339\u914d\u5b57\u6bb5\uff1a%s\u7684\u9009\u62e9\u5668\u7c7b\u578b\u6709\u8bef", field.getDescription()));
        }
        return Optional.empty();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public MainMatchFieldType getType() {
        return this.type;
    }

    public List<Integer> getTimeRange() {
        return this.timeRange;
    }

    public String getMonthPattern() {
        return this.monthPattern;
    }

    public SmartMatchFieldKind getKind() {
        return this.kind;
    }

    public SmartMatchFieldUseKind getUseKind() {
        return this.useKind;
    }

    private SmartMatchField(String value, String description, MainMatchFieldType type, List<Integer> timeRange, String monthPattern, SmartMatchFieldKind kind, SmartMatchFieldUseKind useKind) {
        this.value = value;
        this.description = description;
        this.type = type;
        this.timeRange = timeRange;
        this.monthPattern = monthPattern;
        this.kind = kind;
        this.useKind = useKind;
    }
}

