/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.constant.MergeRuleEnum;
import com.xforceplus.seller.config.client.constant.NagertiveRuleEnum;
import com.xforceplus.seller.config.client.constant.SecondMergeRuleEnum;
import com.xforceplus.seller.config.client.model.CombinationFieldBean;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.BillMergerRuleDTO;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BillMergeParser
implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(BillMergeParser.class);

    @Override
    public BillMergerRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        if (CollectionUtils.isEmpty(cfgConfigItemEntities)) {
            return null;
        }
        BillMergerRuleDTO billMergerRuleDTO = new BillMergerRuleDTO();
        for (MsConfigItemBean msConfigItemBean : cfgConfigItemEntities) {
            List combinationFieldBeanList;
            String itemlistJson;
            StringBuilder sb;
            billMergerRuleDTO.setRuldId(msConfigItemBean.getConfigId());
            String fieldName = msConfigItemBean.getConfigItemName();
            if (StringUtils.isEmpty((CharSequence)fieldName)) continue;
            ArrayList itemValueList = msConfigItemBean.getConfigItemValue();
            if (CollectionUtils.isEmpty(itemValueList)) {
                logger.info("BillMergeParser--itemValueList--parse--Merge\u914d\u7f6e\u9879\u503c\u8bbe\u7f6e\u9519\u8bef:null");
                itemValueList = Lists.newArrayList((Object[])new String[]{""});
            }
            String itemValue = itemValueList.get(0);
            if ("autoAssociationFlag".equals(fieldName)) {
                billMergerRuleDTO.setAutoAssociationFlag(itemValue);
                continue;
            }
            if ("autoMergeFlag".equals(fieldName)) {
                billMergerRuleDTO.setAutoMergeFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("secondMergeFlag".equals(fieldName)) {
                if (CommonTools.isEmpty((String)fieldName)) {
                    billMergerRuleDTO.setSecondMergeFlag(false);
                    continue;
                }
                billMergerRuleDTO.setSecondMergeFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("associationCondition".equals(fieldName) || "defaultAssociationCondition".equals(fieldName) || "associationConditionItem".equals(fieldName)) {
                sb = new StringBuilder();
                if (itemValueList.size() <= 0) continue;
                sb.append("[");
                itemValueList.forEach(m -> {
                    sb.append((String)m);
                    sb.append(",");
                });
                sb.append("]");
                itemlistJson = sb.toString().replace(",]", "]");
                combinationFieldBeanList = JsonUtils.writeJsonToListObject((String)itemlistJson, CombinationFieldBean.class);
                if (billMergerRuleDTO.getAssociationCondition() == null) {
                    billMergerRuleDTO.setAssociationCondition(combinationFieldBeanList);
                    continue;
                }
                billMergerRuleDTO.getAssociationCondition().addAll(combinationFieldBeanList);
                continue;
            }
            if ("mergerCondition".equals(fieldName) || "defaultMergerCondition".equals(fieldName) || "mergerConditionItem".equals(fieldName)) {
                sb = new StringBuilder();
                if (itemValueList.size() <= 0) continue;
                sb.append("[");
                itemValueList.forEach(m -> {
                    sb.append((String)m);
                    sb.append(",");
                });
                sb.append("]");
                itemlistJson = sb.toString().replace(",]", "]").replace(" ", "");
                combinationFieldBeanList = JsonUtils.writeJsonToListObject((String)itemlistJson, CombinationFieldBean.class);
                if (billMergerRuleDTO.getMergerCondition() == null) {
                    billMergerRuleDTO.setMergerCondition(combinationFieldBeanList);
                    continue;
                }
                billMergerRuleDTO.getMergerCondition().addAll(combinationFieldBeanList);
                continue;
            }
            if ("secondMergeCondition".equals(fieldName) || "defaultSecondMergeCondition".equals(fieldName) || "secondMergeConditionItem".equals(fieldName)) {
                sb = new StringBuilder();
                if (itemValueList.size() <= 0) continue;
                sb.append("[");
                itemValueList.forEach(m -> {
                    sb.append((String)m);
                    sb.append(",");
                });
                sb.append("]");
                itemlistJson = sb.toString().replace(",]", "]").replace(" ", "");
                combinationFieldBeanList = JsonUtils.writeJsonToListObject((String)itemlistJson, CombinationFieldBean.class);
                if (billMergerRuleDTO.getSecondMergeCondition() == null) {
                    billMergerRuleDTO.setSecondMergeCondition(combinationFieldBeanList);
                    continue;
                }
                billMergerRuleDTO.getSecondMergeCondition().addAll(combinationFieldBeanList);
                continue;
            }
            if ("mergeRule".equals(fieldName)) {
                billMergerRuleDTO.setMergeRule(MergeRuleEnum.getvalueByValue(Integer.parseInt(itemValue)));
                continue;
            }
            if ("nagertiveRule".equals(fieldName)) {
                billMergerRuleDTO.setNagertiveRule(NagertiveRuleEnum.getvalueByValue(Integer.parseInt(itemValue)));
                continue;
            }
            if ("secondNagertiveRule".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) continue;
                billMergerRuleDTO.setSecondNagertiveRule(SecondMergeRuleEnum.getvalueByValue(Integer.parseInt(itemValue)));
                continue;
            }
            if ("secondMergeRule".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) {
                    itemValue = "4";
                }
                billMergerRuleDTO.setSecondMergeRule(MergeRuleEnum.getvalueByValue(Integer.parseInt(itemValue)));
                continue;
            }
            if ("invoiceLimit".equals(fieldName)) {
                billMergerRuleDTO.setInvoiceLimit(itemValue);
                continue;
            }
            if ("extStr".equals(fieldName)) {
                billMergerRuleDTO.setExtStr(itemValue);
                continue;
            }
            if ("commonInvoiceTypeBound".equals(fieldName)) {
                billMergerRuleDTO.setCommonInvoiceTypeBound(itemValue);
                continue;
            }
            if ("commonElectronicInvoiceTypeBound".equals(fieldName)) {
                billMergerRuleDTO.setCommonElectronicInvoiceTypeBound(itemValue);
                continue;
            }
            if ("specialInvoiceTypeBound".equals(fieldName)) {
                billMergerRuleDTO.setSpecialInvoiceTypeBound(itemValue);
                continue;
            }
            if ("specialElectronicInvoiceTypeBound".equals(fieldName)) {
                billMergerRuleDTO.setSpecialElectronicInvoiceTypeBound(itemValue);
                continue;
            }
            if ("presentMergeFlag".equals(fieldName)) {
                billMergerRuleDTO.setPresentMergeFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("remarkJoinLimitFlag".equals(fieldName)) {
                billMergerRuleDTO.setRemarkJoinLimitFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if (!"enableAccAmountConsistent".equals(fieldName)) continue;
            billMergerRuleDTO.setEnableAccAmountConsistent(Boolean.parseBoolean(itemValue));
        }
        return billMergerRuleDTO;
    }
}

