/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.SysInfoRuleDTO;
import io.vavr.Lazy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SysInfoRuleParser
implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(SysInfoRuleParser.class);
    private static final Map<String, BiConsumer<SysInfoRuleDTO, String>> STRING_VALUE_CONVERT_MAP = (Map)Lazy.of(() -> {
        HashMap map = Maps.newHashMap();
        map.put("sendMailFlag", SysInfoRuleDTO::setSendMailFlag);
        map.put("taxInvoiceSource", SysInfoRuleDTO::setTaxInvoiceSource);
        map.put("redInvoiceReason", SysInfoRuleDTO::setRedInvoiceReason);
        map.put("customerNo", SysInfoRuleDTO::setCustomerNo);
        map.put("invoiceTitlePhoneRequired", SysInfoRuleDTO::setInvoiceTitlePhoneRequired);
        map.put("followWechat", SysInfoRuleDTO::setFollowWechat);
        map.put("orderSearchCondition", SysInfoRuleDTO::setOrderSearchCondition);
        map.put("orderSearchSource", SysInfoRuleDTO::setOrderSearchSource);
        map.put("invoiceTitleCustomFieldName", SysInfoRuleDTO::setInvoiceTitleCustomFieldName);
        map.put("invoiceTitleCustomFieldRequired", SysInfoRuleDTO::setInvoiceTitleCustomFieldRequired);
        map.put("canRepeatInvoice", SysInfoRuleDTO::setCanRepeatInvoice);
        map.put("autoMakeTerminal", SysInfoRuleDTO::setAutoMakeTerminal);
        map.put("invoiceFixedGoodsNo", SysInfoRuleDTO::setInvoiceFixedGoodsNo);
        map.put("goodsMatch", SysInfoRuleDTO::setGoodsMatch);
        map.put("bulkOrderQueryFlag", SysInfoRuleDTO::setBulkOrderQueryFlag);
        map.put("salesBillApplyInvoiceHint", SysInfoRuleDTO::setSalesBillApplyInvoiceHint);
        map.put("thirdPartyCode", SysInfoRuleDTO::setThirdPartyCode);
        map.put("validSameStore", SysInfoRuleDTO::setValidSameStore);
        map.put("taxInvoiceSourceForInterfaceRedFlush", SysInfoRuleDTO::setTaxInvoiceSourceForInterfaceRedFlush);
        return map;
    }).get();
    private static final Map<String, BiConsumer<SysInfoRuleDTO, List<String>>> STRING_VALUES_CONVERT_MAP = (Map)Lazy.of(() -> {
        HashMap map = Maps.newHashMap();
        map.put("uploadCheckByQd", SysInfoRuleDTO::setUploadCheckByQd);
        map.put("enableAdvancedValidation", SysInfoRuleDTO::setEnableAdvancedValidation);
        map.put("invoiceTitleApplyInvoiceType", SysInfoRuleDTO::setInvoiceTitleApplyInvoiceType);
        map.put("uploadBillAutoMake-electronic", SysInfoRuleDTO::setUploadBillAutoMakeElectronic);
        map.put("rejectApplyRepeatFlag", SysInfoRuleDTO::setRejectApplyRepeatFlag);
        map.put("sellerAndPurchaserControl", SysInfoRuleDTO::setSellerAndPurchaserControl);
        map.put("qdCashierAndInvoicerViewConfig", SysInfoRuleDTO::setQdCashierAndInvoicerViewConfig);
        return map;
    }).get();
    private static final Map<String, BiConsumer<SysInfoRuleDTO, Integer>> INTEGER_VALUE_CONVERT_MAP = (Map)Lazy.of(() -> {
        HashMap map = Maps.newHashMap();
        map.put("bill2PreviewInvoiceSkipFlag", SysInfoRuleDTO::setBill2PreviewInvoiceSkipFlag);
        map.put("orgTypeView", SysInfoRuleDTO::setOrgTypeView);
        return map;
    }).get();
    private static final Map<String, BiConsumer<SysInfoRuleDTO, List<Integer>>> INTEGER_VALUES_CONVERT_MAP = (Map)Lazy.of(() -> {
        HashMap map = Maps.newHashMap();
        map.put("elecInvoiceRedFlushReleaseFalg", SysInfoRuleDTO::setElecInvoiceRedFlushReleaseFalg);
        map.put("spePaperInoviceRedFlushReleaseFalg", SysInfoRuleDTO::setSpePaperInoviceRedFlushReleaseFalg);
        map.put("spePaperInoviceDrawftReleaseFlag", SysInfoRuleDTO::setSpePaperInoviceDrawftReleaseFlag);
        map.put("comPaperInoviceDrawftReleaseFlag", SysInfoRuleDTO::setComPaperInoviceDrawftReleaseFlag);
        map.put("comPaperInvoiceRedFlushReleaseFlag", SysInfoRuleDTO::setComPaperInvoiceRedFlushReleaseFlag);
        map.put("vehicleInvoiceRedFlushReleaseFlag", SysInfoRuleDTO::setVehicleInvoiceRedFlushReleaseFlag);
        map.put("speElecInvoiceRedFlushReleaseFlag", SysInfoRuleDTO::setSpeElecInvoiceRedFlushReleaseFlag);
        return map;
    }).get();
    private static final Map<String, BiConsumer<SysInfoRuleDTO, Boolean>> BOOL_VALUE_CONVERT_MAP = (Map)Lazy.of(() -> {
        HashMap map = Maps.newHashMap();
        map.put("checkRedBillFalg", SysInfoRuleDTO::setCheckRedBillFalg);
        map.put("checkRedBillOriginInvoiceFalg", SysInfoRuleDTO::setCheckRedBillOriginInvoiceFalg);
        map.put("checkARBillPurchaseInfoFalg", SysInfoRuleDTO::setCheckARBillPurchaseInfoFalg);
        map.put("checkAPBillSellerInfoFalg", SysInfoRuleDTO::setCheckAPBillSellerInfoFalg);
        map.put("autoUpdateTaxCodeFlag", SysInfoRuleDTO::setAutoUpdateTaxCodeFlag);
        map.put("comInvoiceNeedShortNameFlag", SysInfoRuleDTO::setComInvoiceNeedShortNameFlag);
        map.put("reffiendOilMixOpenFlag", SysInfoRuleDTO::setReffiendOilMixOpenFlag);
        map.put("checkTaxRateByConvertCodeFlag", SysInfoRuleDTO::setCheckTaxRateByConvertCodeFlag);
        map.put("prePayCardAutoOneGoodFlag", SysInfoRuleDTO::setPrePayCardAutoOneGoodFlag);
        map.put("comInvoiceAllowSameSellerOrPurcherFlg", SysInfoRuleDTO::setComInvoiceAllowSameSellerOrPurcherFlg);
        map.put("paperInvoiceMakeAutosendPdfFlag", SysInfoRuleDTO::setPaperInvoiceMakeAutosendPdfFlag);
        map.put("invoiceMakeRemindPrintBillBackGroundFlag", SysInfoRuleDTO::setInvoiceMakeRemindPrintBillBackGroundFlag);
        map.put("autoSplitPreCardFlag", SysInfoRuleDTO::setAutoSplitPreCardFlag);
        map.put("speInvoiceAllowSameSellerOrPurcharseFlag", SysInfoRuleDTO::setSpeInvoiceAllowSameSellerOrPurcharseFlag);
        map.put("invoiceLock", SysInfoRuleDTO::setInvoiceLock);
        map.put("elecInvoiceNeedShortNameFlag", SysInfoRuleDTO::setElecInvoiceNeedShortNameFlag);
        map.put("elecInvoiceMakeAutoSendEmailFlag", SysInfoRuleDTO::setElecInvoiceMakeAutoSendEmailFlag);
        map.put("speInvoiceNeedShortNameFlag", SysInfoRuleDTO::setSpeInvoiceNeedShortNameFlag);
        map.put("autoSplitDiscountFlag", SysInfoRuleDTO::setAutoSplitDiscountFlag);
        map.put("checkTerminalFailIssueRetry", SysInfoRuleDTO::setCheckTerminalFailIssueRetry);
        map.put("qdForceBackCalculateTaxAmount", SysInfoRuleDTO::setQdForceBackCalculateTaxAmount);
        map.put("mobileEmailFillingMethod", SysInfoRuleDTO::setMobileEmailFillingMethod);
        map.put("allowReissue", SysInfoRuleDTO::setAllowReissue);
        map.put("allowAddIssuer", SysInfoRuleDTO::setAllowAddIssuer);
        map.put("isAutoSelectIssuerFlag", SysInfoRuleDTO::setIsAutoSelectIssuerFlag);
        map.put("sendToAntFlag", SysInfoRuleDTO::setSendToAntFlag);
        map.put("reconFlag", SysInfoRuleDTO::setReconFlag);
        map.put("autoGenerateInvoiceGoods", SysInfoRuleDTO::setAutoGenerateInvoiceGoods);
        map.put("jdcSpecialTypeFlag", SysInfoRuleDTO::setJdcSpecialTypeFlag);
        return map;
    }).get();
    private static final Map<String, BiConsumer<SysInfoRuleDTO, Boolean>> BOOL_VALUE_CONVERT_DEFAULT_FALSE_MAP = (Map)Lazy.of(() -> {
        HashMap map = Maps.newHashMap();
        map.put("checkEIvoiceDisplayOthers", SysInfoRuleDTO::setCheckEIvoiceDisplayOthers);
        map.put("modelACombineSetZeroToNotIssue", SysInfoRuleDTO::setModelACombineSetZeroToNotIssue);
        return map;
    }).get();

    @Override
    public SysInfoRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        SysInfoRuleDTO sysInfoRuleDTO = new SysInfoRuleDTO();
        for (MsConfigItemBean msConfigItemBean : cfgConfigItemEntities) {
            sysInfoRuleDTO.setRuldId(msConfigItemBean.getConfigId());
            String fieldName = msConfigItemBean.getConfigItemName();
            ArrayList itemValueList = msConfigItemBean.getConfigItemValue();
            if (CommonTools.isEmpty((String)fieldName)) continue;
            if (CollectionUtils.isEmpty(itemValueList)) {
                itemValueList = Lists.newArrayList((Object[])new String[]{""});
            }
            String itemValue = itemValueList.get(0);
            if ("uploadNagertiveMixBillFlag".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) {
                    logger.info("\u6ca1\u6709\u627e\u5230\u7cfb\u7edf\u914d\u7f6e\u9879uploadNagertiveMixBillFlag");
                    sysInfoRuleDTO.setUploadNagertiveMixBillFlag(false);
                    continue;
                }
                sysInfoRuleDTO.setUploadNagertiveMixBillFlag(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("uploadBillAutoConfirm".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) {
                    logger.info("uploadBillAutoConfirm");
                    sysInfoRuleDTO.setUploadBillAutoConfirm(true);
                    continue;
                }
                sysInfoRuleDTO.setUploadBillAutoConfirm(Boolean.parseBoolean(itemValue));
                continue;
            }
            if ("billTolerance".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue) || !Pattern.compile("^[0-9]\\d{0,13}(\\.\\d{0,4})?$").matcher(itemValue).matches()) {
                    logger.error("\u53d1\u7968\u5339\u914d\u4e1a\u52a1\u5355\u914d\u7f6e\u9879\u503c\u5bb9\u5dee\u53ea\u80fd\u4e3a2\u4f4d\u5c0f\u6570\u91d1\u989d\u6570\u636e\uff0c\u4f20\u5165\u503c\uff1a{}", (Object)itemValue);
                    itemValue = String.valueOf(0);
                }
                sysInfoRuleDTO.setBillTolerance(new BigDecimal(itemValue).setScale(2, 4));
                continue;
            }
            if ("bizBillDiscountRate".equals(fieldName)) {
                if (!CommonTools.isEmpty((String)itemValue)) {
                    sysInfoRuleDTO.setBizBillDiscountRate(itemValue);
                    continue;
                }
                sysInfoRuleDTO.setBizBillDiscountRate("1");
                continue;
            }
            if ("invoiceMatchTolerance".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue) || !Pattern.compile("^[0-9]\\d{0,13}(\\.\\d{0,4})?$").matcher(itemValue).matches()) {
                    itemValue = String.valueOf(0);
                }
                sysInfoRuleDTO.setInvoiceMatchTolerance(new BigDecimal(itemValue).setScale(2, 4));
                continue;
            }
            if ("updateARBillAndCasm".equals(fieldName)) {
                if (StringUtils.isBlank((CharSequence)itemValue)) {
                    itemValue = "false";
                }
                sysInfoRuleDTO.setUpdateARBillAndCasm(itemValue);
                continue;
            }
            if ("updateARBillAndGoods".equals(fieldName)) {
                if (StringUtils.isBlank((CharSequence)itemValue)) {
                    itemValue = "false";
                }
                sysInfoRuleDTO.setUpdateARBillAndGoods(itemValue);
                continue;
            }
            if ("redNoCompareTolerance".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue) || !Pattern.compile("^[0-9]\\d{0,13}(\\.\\d{0,4})?$").matcher(itemValue).matches()) {
                    logger.error("\u7ea2\u5b57\u4fe1\u606f\u6bd4\u5bf9\u5bb9\u5dee\u53ea\u80fd\u4e3a2\u4f4d\u5c0f\u6570\u91d1\u989d\u6570\u636e\uff0c\u4f20\u5165\u503c\uff1a{}", (Object)itemValue);
                    itemValue = String.valueOf(0);
                }
                sysInfoRuleDTO.setRedNoCompareTolerance(new BigDecimal(itemValue).setScale(2, 4));
                continue;
            }
            if ("billManualTag".equals(fieldName)) {
                sysInfoRuleDTO.setBillManualTag(NumberUtils.isCreatable((String)itemValue) ? Integer.parseInt(itemValue) : 2);
                continue;
            }
            if ("billManualTagRule".equals(fieldName)) {
                sysInfoRuleDTO.setBillManualTagRule(NumberUtils.isCreatable((String)itemValue) ? Integer.parseInt(itemValue) : 0);
                continue;
            }
            if (StringUtils.equals((CharSequence)"recommendGoodsType", (CharSequence)fieldName)) {
                sysInfoRuleDTO.setRecommendGoodsType(NumberUtils.isCreatable((String)itemValue) ? Integer.parseInt(itemValue) : 2);
                continue;
            }
            if ("modifyTaxRateFlag".equals(fieldName)) {
                sysInfoRuleDTO.setModifyTaxRateFlag(NumberUtils.isCreatable((String)itemValue) ? Integer.parseInt(itemValue) : 0);
                continue;
            }
            if (StringUtils.equals((CharSequence)"qdSellerTitle", (CharSequence)fieldName)) {
                sysInfoRuleDTO.setQdSellerTitle(NumberUtils.isCreatable((String)itemValue) ? Integer.parseInt(itemValue) : 2);
                continue;
            }
            if (StringUtils.equals((CharSequence)"redBillAutoConfirmFlag", (CharSequence)fieldName)) {
                sysInfoRuleDTO.setRedBillAutoConfirmFlag("true".equals(itemValue));
                continue;
            }
            if (StringUtils.equals((CharSequence)"redBillMatchRedConfirmMatchConfig", (CharSequence)fieldName)) {
                sysInfoRuleDTO.setRedBillMatchRedConfirmMatchConfig("true".equals(itemValue));
                continue;
            }
            if (StringUtils.equals((CharSequence)"smallScaleTaxpayerChangeToCommonInvoice", (CharSequence)fieldName)) {
                sysInfoRuleDTO.setSmallScaleTaxpayerChangeToCommonInvoice("true".equals(itemValue));
                continue;
            }
            if (StringUtils.equals((CharSequence)"purchaserTitleMatchType", (CharSequence)fieldName)) {
                sysInfoRuleDTO.setPurchaserTitleMatchType(NumberUtils.isCreatable((String)itemValue) ? Integer.parseInt(itemValue) : 0);
                continue;
            }
            if (!this.stringValueConvert(sysInfoRuleDTO, fieldName, itemValue) && !this.stringValuesConvert(sysInfoRuleDTO, fieldName, itemValueList) && !this.integerValueConvert(sysInfoRuleDTO, fieldName, itemValue) && !this.integerValuesConvert(sysInfoRuleDTO, fieldName, itemValueList) && !this.boolValueConvert(sysInfoRuleDTO, fieldName, itemValue) && !this.boolValueConvertDefaultFalse(sysInfoRuleDTO, fieldName, itemValue)) continue;
        }
        return sysInfoRuleDTO;
    }

    private boolean stringValueConvert(SysInfoRuleDTO sysInfoRuleDTO, String fieldName, String itemValue) {
        boolean hitField = STRING_VALUE_CONVERT_MAP.containsKey(fieldName);
        if (hitField) {
            Optional.ofNullable(STRING_VALUE_CONVERT_MAP.get(fieldName)).ifPresent(consumer -> consumer.accept(sysInfoRuleDTO, itemValue));
        }
        return hitField;
    }

    private boolean stringValuesConvert(SysInfoRuleDTO sysInfoRuleDTO, String fieldName, List<String> itemValues) {
        boolean hitField = STRING_VALUES_CONVERT_MAP.containsKey(fieldName);
        if (hitField && !StringUtils.isEmpty((CharSequence)itemValues.get(0))) {
            Optional.ofNullable(STRING_VALUES_CONVERT_MAP.get(fieldName)).ifPresent(consumer -> consumer.accept(sysInfoRuleDTO, itemValues));
        }
        return hitField;
    }

    private boolean integerValueConvert(SysInfoRuleDTO sysInfoRuleDTO, String fieldName, String itemValue) {
        boolean hitField = INTEGER_VALUE_CONVERT_MAP.containsKey(fieldName);
        if (hitField && !StringUtils.isEmpty((CharSequence)itemValue)) {
            Optional.ofNullable(INTEGER_VALUE_CONVERT_MAP.get(fieldName)).ifPresent(consumer -> consumer.accept(sysInfoRuleDTO, Integer.valueOf(itemValue)));
        }
        return hitField;
    }

    private boolean integerValuesConvert(SysInfoRuleDTO sysInfoRuleDTO, String fieldName, List<String> itemValues) {
        boolean hitField = INTEGER_VALUES_CONVERT_MAP.containsKey(fieldName);
        if (hitField && !StringUtils.isEmpty((CharSequence)itemValues.get(0))) {
            Optional.ofNullable(INTEGER_VALUES_CONVERT_MAP.get(fieldName)).ifPresent(consumer -> consumer.accept(sysInfoRuleDTO, itemValues.stream().map(Integer::valueOf).collect(Collectors.toList())));
        }
        return hitField;
    }

    private boolean boolValueConvert(SysInfoRuleDTO sysInfoRuleDTO, String fieldName, String itemValue) {
        boolean hitField = BOOL_VALUE_CONVERT_MAP.containsKey(fieldName);
        if (hitField) {
            Optional.ofNullable(BOOL_VALUE_CONVERT_MAP.get(fieldName)).ifPresent(consumer -> consumer.accept(sysInfoRuleDTO, Boolean.parseBoolean(itemValue)));
        }
        return hitField;
    }

    private boolean boolValueConvertDefaultFalse(SysInfoRuleDTO sysInfoRuleDTO, String fieldName, String itemValue) {
        boolean hitField = BOOL_VALUE_CONVERT_DEFAULT_FALSE_MAP.containsKey(fieldName);
        if (hitField) {
            Optional.ofNullable(BOOL_VALUE_CONVERT_DEFAULT_FALSE_MAP.get(fieldName)).ifPresent(consumer -> consumer.accept(sysInfoRuleDTO, "true".equals(itemValue)));
        }
        return hitField;
    }
}

