package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.ImportReasonRequest;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigUserIssuerRelationData;
import com.xforceplus.seller.config.client.model.PageQueryData;
import com.xforceplus.xplatframework.apimodel.file.ImportResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 *导入配置失败生成excl
 * ，并通知消息中心
 */
@Api(value = "configImport", description = "the configImportReason API")
public interface ConfigImportReasonApi {

    @ApiOperation(value = "生成导入Excel失败原因", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags = {"configImport",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = Response.class)})
    @RequestMapping(value = "/generate/config-import-reason",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response generateConfigImportReason(@ApiParam(value = "查询自定义条件请求", required = true) @RequestBody ImportReasonRequest reasonRequest);

    @ApiOperation(
            value = "查询配置导入结果",
            notes = "",
            response = ImportResponse.class,
            authorizations = {@Authorization("x-access-token")},
            tags = {"configImport"}
    )
    @ApiResponses({@ApiResponse(
            code = 200,
            message = "查询结果",
            response = ImportResponse.class
    )})
    @RequestMapping(
            value = {"/config-import/result"},
            produces = {"application/json"},
            method = {RequestMethod.GET}
    )
    ImportResponse getImportResult(@ApiParam("任务id") @RequestParam(value = "importBatchNo", required = false) Long importBatchNo);


    @ApiOperation(
            value = "查询配置导入结果",
            notes = "",
            response = ImportResponse.class,
            authorizations = {@Authorization("x-access-token")},
            tags = {"configImport"}
    )
    @ApiResponses({@ApiResponse(
            code = 200,
            message = "查询结果",
            response = ImportResponse.class
    )})
    @RequestMapping(
            value = {"/config-import/result-all"},
            produces = {"application/json"},
            method = {RequestMethod.GET}
    )
    ImportResponse getBusinessConfigImportResult(@RequestParam(value = "importBatchNo", required = false) Long importBatchNo);

    @ApiOperation(
            value = "查询配置导出结果",
            notes = "",
            response = Response.class,
            authorizations = {@Authorization("x-access-token")},
            tags = {"configImport"}
    )
    @ApiResponses({@ApiResponse(
            code = 200,
            message = "查询结果",
            response = Response.class
    )})
    @RequestMapping(
            value = {"/config/export"},
            produces = {"application/json"},
            method = {RequestMethod.POST}
    )
    Response exportConfig(@ApiParam(value = "用户查询配置") @RequestBody MsConfigQueryRequestWithUserInfo request);

    @ApiOperation(
            value = "统计用户开票人（或设备）关系数量",
            notes = "",
            response = Response.class,
            authorizations = {@Authorization("x-access-token")},
            tags = {"configImport"}
    )
    @ApiResponses({@ApiResponse(
            code = 200,
            message = "查询结果",
            response = Response.class
    )})
    @RequestMapping(
            value = {"/config/getUserIssuerRelationCount"},
            produces = {"application/json"},
            method = {RequestMethod.POST}
    )
    Response getUserIssuerRelationCount(@ApiParam(value = "统计用户开票人（或设备）关系数量") @RequestBody MsConfigUserIssuerRelationData.MsConfigUserIssuerRelationConditionRequest request);


    @ApiOperation(
            value = "查询用户开票人（或设备）关系List",
            notes = "",
            response = Response.class,
            authorizations = {@Authorization("x-access-token")},
            tags = {"configImport"}
    )
    @ApiResponses({@ApiResponse(
            code = 200,
            message = "查询结果",
            response = Response.class
    )})
    @RequestMapping(
            value = {"/config/queryUserIssuerRelationList"},
            produces = {"application/json"},
            method = {RequestMethod.POST}
    )
    Response<PageQueryData<MsConfigUserIssuerRelationData.UserIssuerRelationVo>> queryUserIssuerRelationList( @RequestBody MsConfigUserIssuerRelationData.MsConfigUserIssuerRelationConditionRequest request);

    @ApiOperation(
            value = "查询配置导入人员关系结果",
            notes = "",
            response = ImportResponse.class,
            authorizations = {@Authorization("x-access-token")},
            tags = {"configImport"}
    )
    @ApiResponses({@ApiResponse(
            code = 200,
            message = "查询结果",
            response = ImportResponse.class
    )})
    @RequestMapping(
            value = {"/config/getImportUserIssuerRelationResult"},
            produces = {"application/json"},
            method = {RequestMethod.GET}
    )
    ImportResponse getImportUserIssuerRelationResult(@RequestParam(value = "importBatchNo", required = false) Long importBatchNo);


}