package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.MsConfigQueryInvoiceTypeRequest;
import com.xforceplus.seller.config.client.model.MsQueryInvoiceTypeResponse;

import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value = "configSystem", description = "the configSystem API")
public interface ConfigSystemApi {

    @ApiOperation(value = "查询发票类型", notes = "", response = MsQueryInvoiceTypeResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "SellerConfigSystem", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询发票类型响应", response = MsQueryInvoiceTypeResponse.class) })
    @RequestMapping(value = "/configSystem/queryInvoiceType",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsQueryInvoiceTypeResponse queryInvoiceType(@ApiParam(value = "查询发票类型" ,required=true ) @RequestBody MsConfigQueryInvoiceTypeRequest configQueryInvoiceTypeRequest);


//    @ApiOperation(value = "系统规则制定项配置查询（去业务单类型条件）", notes = "", response = MsQueryInvoiceTypeResponse.class, authorizations = {
//            @Authorization(value = "x-access-token")
//    }, tags={ "SellerConfigSystem", })
//    @ApiResponses(value = {
//            @ApiResponse(code = 200, message = "查询发票类型响应", response = MsQueryInvoiceTypeResponse.class) })
//    @RequestMapping(value = "/configSystem/queryGroupConfigItemValue",
//            produces = { "application/json" },
//            method = RequestMethod.POST)
//    Response<Boolean> queryGroupConfigItemValue(@ApiParam(value = "查询一组系统配置项的值" ,required=true) @RequestBody MsConfigQueryRequest msConfigQueryRequest);
}
