package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.MsCustomDefinitionResponse;
import com.xforceplus.seller.config.client.model.MsExportCustomFieldResponse;
import com.xforceplus.seller.config.client.model.MsImportFieldResponse;

import com.xforceplus.seller.config.client.model.UserCustomDefinitionRequest;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "custom-definition", description = "the custom-definition API")
public interface CustomDefinitionApi {

    @ApiOperation(value = "查询用户自定义", notes = "", response = MsCustomDefinitionResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "CustomDefinitions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询响应", response = MsCustomDefinitionResponse.class) })
    @RequestMapping(value = "/custom-definition/query-custom-definition",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsCustomDefinitionResponse getCustomDefinition( @ApiParam(value = "用户id") @RequestParam(value = "userId", required = false) Long userId, @ApiParam(value = "集团id") @RequestParam(value = "tenantId", required = false) Long tenantId, @ApiParam(value = "页面代码") @RequestParam(value = "pageCode", required = false) String pageCode, @ApiParam(value = "功能点代码") @RequestParam(value = "functionPoint", required = false) String functionPoint);


    @ApiOperation(value = "查询用户自定义导入字段", notes = "", response = MsImportFieldResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "CustomDefinitions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询响应", response = MsImportFieldResponse.class) })
    @RequestMapping(value = "/custom-definition/query-custom-import-fields",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsImportFieldResponse getCustomImportFields( @ApiParam(value = "用户id") @RequestParam(value = "userId", required = false) Long userId, @ApiParam(value = "集团id") @RequestParam(value = "tenantId", required = false) Long tenantId, @ApiParam(value = "页面代码") @RequestParam(value = "pageCode", required = false) String pageCode, @ApiParam(value = "功能点代码") @RequestParam(value = "functionPoint", required = false) String functionPoint);


    @ApiOperation(value = "查询自定义元数据对象", notes = "", response = MsExportCustomFieldResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "CustomDefinitions", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "查询响应", response = MsExportCustomFieldResponse.class) })
    @RequestMapping(value = "/custom-definition/queryCustomCfgBusinessObjMetadata4Export",
        produces = { "application/json" },
        method = RequestMethod.GET)
     MsExportCustomFieldResponse queryCustomCfgBusinessObjMetadata4Export( @ApiParam(value = "集团id") @RequestParam(value = "groupId", required = false) Long groupId, @ApiParam(value = "模板编码") @RequestParam(value = "objCode", required = false) String objCode, @ApiParam(value = "单据对象类型") @RequestParam(value = "objType", required = false) String objType);

    @ApiOperation(value = "查询自定义元数据对象", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "CustomDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = Response.class) })
    @RequestMapping(value = "/custom-definition/getUserCustomDefinition",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response getUserCustomDefinition(@ApiParam(value = ""  ) @RequestBody UserCustomDefinitionRequest userCustomDefinitionRequest);

}
