package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.*;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;


@Api(value = "config", description = "the config API")
public interface ObjectMetadataApi {

    @ApiOperation(value = "业务单扩展字段定义修改", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/object/field/action/add-enum-value",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
    ResponseV2<ObjectFieldAddEnumValueResult> addEnumValue(@ApiParam(value = "查询配置明细"  ) @RequestBody List<ObjectFieldEnumValueDTO> objectFieldEnumValueDTOS);
}
