package com.xforceplus.seller.config.client.api;


import com.xforceplus.seller.config.client.model.SearchModel;
import com.xforceplus.seller.config.client.model.TaxNationalCode;
import com.xforceplus.seller.config.client.model.TaxNationalCodeResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

@Api(value = "goods", description = "the goods  API")
public interface TaxCodeNationalApi {


    @ApiOperation(value = "根据税遍名称查询国税局信息", notes = "", response = TaxNationalCodeResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "nationalTaxCode", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = TaxNationalCodeResponse.class) })
    @PostMapping(value = "/taxCodeNational/getNationalTaxCodeByTaxCodeName")
    TaxNationalCodeResponse getNationalTaxCodeByTaxCodeName(@ApiParam(value = "税编名称", required = true) @RequestParam(value = "taxCodeName", required = true) String taxCodeName);


    @ApiOperation(value = "根据税编号码查询国税局信息（模糊搜索）", notes = "", response = TaxNationalCodeResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "nationalTaxCode", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = TaxNationalCodeResponse.class) })
    @PostMapping(value = "/taxCodeNational/getNationalTaxCodeByGoodsTaxNo")
    TaxNationalCodeResponse getNationalTaxCodeByGoodsTaxNo(@ApiParam(value = "税编号码", required = true) @RequestParam(value = "goodTaxNo", required = true) String goodTaxNo);

    @ApiOperation(value = "根据税编号码查询国税局信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "nationalTaxCode", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class) })
    @RequestMapping(value = "/taxCodeNational/getByGoodsTaxNo",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response getByGoodsTaxNo(@ApiParam(value = "税编号码", required = true) @RequestBody SearchModel model);


    @ApiOperation(value = "根据税编查询国税数据(精确匹配)", notes = "", response = TaxNationalCode.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "TaxCodeNational", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "上传结果", response = TaxNationalCode.class) })
    @RequestMapping(value = "/taxCodeNational/getNationalTaxCode",
            produces = { "application/json" },
            method = RequestMethod.POST)
    TaxNationalCode getNationalTaxCode( @NotNull @ApiParam(value = "税收分类编码", required = true) @RequestParam(value = "goodTaxNo", required = true) String goodTaxNo);



}
