package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.ResponseV2;
import com.xforceplus.seller.config.client.model.TaxInvoiceQuotaInfoModel;
import com.xforceplus.seller.config.client.model.TaxInvoiceQuotaInfoQueryRequest;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;


@Api(value = "taxQuota", description = "the taxQuota API")
public interface TaxInvoiceQuotaInfoApi {

    @ApiOperation(value = "获取开票限额", notes = "", response = ResponseV2.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "taxQuota", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询响应", response = ResponseV2.class) })
    @RequestMapping(value = "/InvoiceSplitQuota/getTaxQuotaInfoByTaxNumber",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
    ResponseV2<List<TaxInvoiceQuotaInfoModel>> getTaxQuotaInfoByTaxNumber(@ApiParam(value = "查询参数"  ) @RequestBody TaxInvoiceQuotaInfoQueryRequest taxInvoiceQuotaInfoQueryRequest);

    @ApiOperation(value = "仅查询数据表里限额", notes = "", response = ResponseV2.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "taxQuota", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = ResponseV2.class) })
    @RequestMapping(value = "/InvoiceSplitQuota/getTaxQuotaInfoByTaxNumbers",
            produces = { "application/json" },
            method = RequestMethod.POST)
    ResponseV2<List<TaxInvoiceQuotaInfoModel>> findTaxQuotaInfoByTaxNumbers(@ApiParam(value = "查询参数"  ) @RequestBody TaxInvoiceQuotaInfoQueryRequest taxInvoiceQuotaInfoQueryRequest);

}
