package com.xforceplus.seller.config.client.constant;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * 发票推送规则，发送时间类型
 */
@RequiredArgsConstructor
@Getter
public enum MailRuleSendTimeType implements ValueEnum<Integer> {
    IMMEDIATELY(0, "立即发送"),
    DAILY(1, "每天发送"),
    MONTHLY(2, "每月发送");

    private final Integer value;
    private final String description;
}
