package com.xforceplus.seller.config.client.constant.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

@Getter
@AllArgsConstructor
public enum AdaptorMode {
    TENANT("租户"),
    AP("购方"),
    AR( "销方");

    private final String desc;

    public static AdaptorMode select(String mode){

        return Arrays.stream(AdaptorMode.values())
                .filter(o -> o.name().equalsIgnoreCase(mode))
                .findFirst()
                .orElseThrow(() -> new RuntimeException("不存在的适配模式:"+mode));
    }
}
