package com.xforceplus.seller.config.client.constant.enums;

import com.xforceplus.seller.config.client.constant.ValueEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum TerminalStatus implements ValueEnum<Integer> {

    WAIT_TO_VERIFY(0, "待审核"),
    VERIFIED_PASSED(1, "审核通过"),
    VERIFIED_NOT_PASSED(2, "审核失败"),
    ENABLED(11, "启用"),
    NOT_ENABLED(12, "未启用"),
    CLOSED(21, "关闭"),
    INVALID(22, "作废");

    private final Integer value;
    private final String desc;

}
