package com.xforceplus.seller.config.client.constant.redconfirmmatch;

import com.xforceplus.seller.config.client.constant.ValueEnum;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
@Getter
public enum MainMatchFieldType implements ValueEnum<String> {

    Enum("e", "枚举类型"),
    String("s", "字符串类型"),
    Month("m", "时间类型（年月）"),
    Timestamp("t", "时间类型（毫秒时间戳）"),
    /**
     * 常规任何数字类型的字段都可以使用，金额、单价、税率等
     */
    BigDecimal("b", "数字类型"),
    /**
     * 小数类型，用于一些特殊场景，表示0-1之间的小数
     */
    Decimal("d", "小数类型");

    private final String value;
    private final String description;

}
