package com.xforceplus.seller.config.client.matchparser;

import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.parse.BaseRuleBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;

import java.util.List;

/**
 * Created by admin on 2018/10/24.
 */
// 规则匹配解析器,根据单据组装的规则对象 从规则配置列表中找到匹配度最高的
public interface ConfigMatchParser {
    /**
     *
     * @param cfgConfigEntities 购销对下的规则列表
     * @param cfgConfigEntity 单据头组装的规则实体
     * @param configParser 规则解析器
     * @return
     */
     BaseRuleBean configMatch(List<MsConfigBean> cfgConfigEntities,MsConfigBean cfgConfigEntity,ConfigParser configParser);

    /**
     * 匹配最优拆分规则
     * @param cfgConfigEntityList 待匹配的拆分规则列表
     * @param cfgConfigEntity 参考对象
     * @param configParser 解析器对象
     * @return 匹配的最优规则
     */
    BaseRuleBean splitConfigRuleMatch(List<MsConfigBean> cfgConfigEntityList,MsConfigBean cfgConfigEntity,ConfigParser configParser);

    MsConfigBean getBestMatchConfig(List<MsConfigBean> targetMsConfigBeanList,MsConfigBean msConfigBeanFromBill);

    /**
     * score same get multi
     * @param targetMsConfigBeanList
     * @param msConfigBeanFromBill
     * @return
     */
    MsConfigBean getBestMatchConfigMulti(List<MsConfigBean> targetMsConfigBeanList,MsConfigBean msConfigBeanFromBill);

}
