package com.xforceplus.seller.config.client.model;

import lombok.Data;

@Data
public class AlipayAppInfoDTO {

    /**
     * 生活号名称
     */
    private String appName;

    /**
     * 生活号头像地址
     */
    private String logoUrl;

    /**
     * 欢迎语
     */
    private String publicGreeting;

    /**
     * 最新审核状态
     * AUDITING：审核中，AUDIT_FAILED：审核驳回，AUDIT_SUCCESS：审核通过，AUDIT_NORMAL：无审核状态（当前没有处于审核过程的工单）
     */
    private String auditStatus;

    /**
     * 最新审核状态描述
     */
    private String auditDesc;

    /**
     * T表示上线，F表示未上线
     */
    private String isOnline;

    /**
     * 生活号是否上架，T表示上架，上架即可在支付宝客户端被搜索到，F表示未上架
     */
    private String isRelease;

    /**
     * 生活号简介
     */
    private String introduction;

    /**
     * 背景图片地址
     */
    private String backgroundUrl;

    /**
     * 商家经营类目
     */
    private String mccCodeDesc;

    /**
     * 关注二维码
     */
    private String qrcodeUrl;

}
