package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 全电开票人列表 - 请求参数
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AllElectricIssuerNoFilterRequest {

    @ApiModelProperty("销方税号列表")
    @JsonProperty("taxNoList")
    private List<String> taxNoList;

    @ApiModelProperty("税号下的开票人")
    @JsonProperty("issuer")
    private String issuer;
}
