package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class CfgAllElectricIssuerRecord implements Serializable {
    @ApiModelProperty("id")
    @JsonProperty("id")
    private Long id;

    @ApiModelProperty("销方税号")
    @JsonProperty("companyTaxNo")
    private String companyTaxNo;

    @ApiModelProperty("销方公司名称")
    @JsonProperty("companyName")
    private String companyName;

    @ApiModelProperty("税号下的开票人")
    @JsonProperty("issuer")
    private String issuer;

    @ApiModelProperty("开票方式 ns-乐企 dppt-电票平台")
    @JsonProperty("issueType")
    private String issueType;

    @ApiModelProperty("唯一标识")
    @JsonProperty("uniqueKey")
    private String uniqueKey;

    @ApiModelProperty("销方集团id")
    @JsonProperty("sellerGroupId")
    private Long sellerGroupId;

    @ApiModelProperty("操作类型 1-新增 2-修改 3-删除")
    @JsonProperty("operateType")
    private Integer operateType;

    @ApiModelProperty("操作人")
    @JsonProperty("operator")
    private String operator;

    @ApiModelProperty("操作人ID")
    @JsonProperty("operatorId")
    private Long operatorId;

    @ApiModelProperty("操作时间")
    @JsonProperty("operateTime")
    private Date operateTime;
}
