package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ConfigAllElectricIssuerInfoRequest implements Serializable {
  @ApiModelProperty("销方税号")
  @JsonProperty("taxNo")
  private String taxNo;

  @ApiModelProperty("税号下的开票人")
  @JsonProperty("issuer")
  private String issuer;

  @ApiModelProperty("开票方式 ns-乐企 dppt-电票平台")
  @JsonProperty("issueType")
  private String issueType;

  @ApiModelProperty("账号")
  @JsonProperty("account")
  private String account;

  @ApiModelProperty("密码")
  @JsonProperty("password")
  private String password;

  @ApiModelProperty("操作人")
  @JsonProperty("operator")
  private String operator;

  @ApiModelProperty("开票人启用状态（enabled-启用 disabled-停用）")
  @JsonProperty("status")
  private String status;

}
