package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * @Author zzw
 * @Description
 * @Date
 * @return
 **/
@ApiModel(description = "配置数据包含元素原始值及当前值")
@JsonInclude(NON_NULL)
@Data
public class ConifgItemDataDTO implements Serializable {
    //字典key
    @ApiModelProperty("配置项名称：发票限额 invoiceLimit")
    @JsonProperty("itemName")
    private String itemName;
    // 字典项值
    @ApiModelProperty("配置项中文名称")
    @JsonProperty("itemDisplayName")
    private String itemDisplayName;
    @ApiModelProperty("表示 配置项相等关系的值单选或文本值{code,value,text} 对于多选值 [{code,value,text}]")
    @JsonProperty("value")
    private List<String> value;
}
