package com.xforceplus.seller.config.client.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;


@Data
@AllArgsConstructor
@NoArgsConstructor
public class CreateSettledTemplateConfigRequest {

    @ApiModelProperty("入驻配置ID")
    private Long id;

    @ApiModelProperty("配置类型;0-通用配置 1-定制配置")
    private Integer configType;

    @ApiModelProperty("配置代码")
    private String configCode;

    @ApiModelProperty("配置分类")
    private String configClass;

    @ApiModelProperty("入驻类型")
    private Integer settledType;

    @ApiModelProperty("入驻租户id")
    private Long tenantId;

    @ApiModelProperty("入驻租户名称")
    private String tenantName;

    @ApiModelProperty("产品代码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("单据类型")
    private String salesbillType;

    @ApiModelProperty("单据是否支持零售;0-非零售 1-零售")
    private Integer toCFlag;

    @ApiModelProperty("入驻描述")
    private String settledDesc;

    private List<List<CfgTemplateObj>> templateGroupList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class CfgTemplateObj  {
        private String templateObjCode;
        private String objCodeExt;
        private String taxInvoiceSource;
        private List<CfgTemplateObjMetadata> cfgTemplateObjMetadataList;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class CfgTemplateObjMetadata {
        private String fieldName;
        private String fieldDisplayName;
        private String fieldGroup;
        private String fieldGroupName;
        private Integer fieldGroupIndex;
        private Integer fieldRequired;
        private String fieldType;
        private String fieldQueryType;
        private String fieldEnumValue;
        private String fieldDefaultValue;
        private Integer fieldLength;
        private Integer fieldSort;
        private Integer fieldGridRow;
        private Integer fieldGridColumn;
        private Integer fieldVisible;
        private Integer fieldReadonly;
        private String displayType;
        private String associativeUrl;
        private Integer virtual;
        private Integer fixed;
        private Integer fixedUpdate;
        private Integer commonUsed;

        private String templateObjCode;
        private String templateObjId;
    }

}
