package com.xforceplus.seller.config.client.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class InitSettledTemplateConfigRequest {
    /**
     * 入驻类型
     */
    private Integer settledType = null;
    /**
     * 产品代码
     */
    private String productCode = null;
    /**
     * 产品名称
     */
    private String productName = null;
    /**
     * 单据类型
     */
    private String salesbillType = null;
    /**
     * 单据是否支持零售
     */
    private Boolean toCFlag = null;
    /**
     * 入驻来源租户id
     */
    private Long tenantId = null;
    /**
     * 入驻租户名称
     */
    private String tenantName = null;

    private List<List<CfgTemplateObj>> templateGroupList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class CfgTemplateObj  {
        private String templateObjCode;
        private String objCodeExt;
        private String taxInvoiceSource;
        private List<CfgTemplateObjMetadata> cfgTemplateObjMetadataList;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class CfgTemplateObjMetadata {
        private String fieldName;
        private String fieldDisplayName;
        private String fieldGroup;
        private String fieldGroupName;
        private Integer fieldGroupIndex;
        private Integer fieldRequired;
        private String fieldType;
        private String fieldQueryType;
        private String fieldEnumValue;
        private String fieldDefaultValue;
        private Integer fieldLength;
        private Integer fieldSort;
        private Integer fieldGridRow;
        private Integer fieldGridColumn;
        private Integer fieldVisible;
        private Integer fieldReadonly;
        private String displayType;
        private String associativeUrl;
        private Integer virtual;
        private Integer fixed;
        private Integer fixedUpdate;
        private Integer commonUsed;
    }

}
