package com.xforceplus.seller.config.client.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

@Data
public class InvoiceFieldConvertConfigStrategyDto implements Serializable {
    /**
     * 条件
     */
    private MainDetailField<OperationField, OperationField> conditions;
    /**
     * 执行
     */
    private MainDetailField<ExecutorOperationField, ExecutorOperationField> executors;
    /**
     * 值字段
     */
    private MainDetailField<Field, Field> valueFields;

    /**
     * 值字段单元
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Field implements Serializable {
        /**
         * 编码
         */
        private String code;
        /**
         * 名称
         */
        private String name;
    }

    /**
     * 操作字段
     */
    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class OperationField extends Field {
        /**
         * 类型
         */
        private String type;
        /**
         * 操作符
         */
        private List<Field> operators;
        /**
         * 枚举集合
         */
        private List<Field> enums;
    }

    /**
     * 主信息，明细配置
     * @param <M> 主信息类型
     * @param <D> 明细类型
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class MainDetailField<M, D> implements Serializable {
        private List<M> main;
        private List<D> detail;
    }

    /**
     * 执行的操作字段
     */
    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class ExecutorOperationField extends Field {
        /**
         * 类型
         */
        private String type;
        /**
         * 操作符
         */
        private List<ExecutorOperator> operators;
        /**
         * 枚举集合
         */
        private List<Field> enums;
    }

    /**
     * 执行的操作符
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ExecutorOperator implements Serializable {
        /**
         * 编码
         */
        private String code;
        /**
         * 名称
         */
        private String name;
        /**
         * 说明
         */
        private String comment;
    }
}
