package com.xforceplus.seller.config.client.model;/**
 * Created by admin on 2018/9/27.
 */

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * @Author zzw
 * @Description
 * @Date
 * @return
 **/
// 表示 前端传输的规则项配置 键值对
@ApiModel("前端传输的规则项配置 键值对")
@JsonInclude(NON_NULL)
public class ItemDTO implements Serializable {
    //字典key
    @ApiModelProperty("配置项名称：发票限额 invoiceLimit")
    @JsonProperty("itemName")
    private String itemName;
    // 字典项值
    @ApiModelProperty("配置项中文名称")
    @JsonProperty("itemDisplayName")
    private String itemDisplayName;
    @ApiModelProperty("表示 配置项相等关系的值")
    @JsonProperty("value")
    private List<String> value;
    @ApiModelProperty("表示 配置项最大值 ")
    @JsonProperty("max")
    private String max;
    @ApiModelProperty("表示 配置项最小值 ")
    @JsonProperty("min")
    private String min;
    @ApiModelProperty("所属主配置ID ")
    @JsonProperty("configId")
    private Long configId;
    @ApiModelProperty("配置项位置  ")
    @JsonProperty("sort")
    private Byte sort;
    // 如果是字典枚举类型 需要将字典code 传过来
    @ApiModelProperty("如果是字典枚举类型 需要将字典code 传过来，表示 value 对于的值所属的 字典code")
    @JsonProperty("dictCode")
    private String dictCode;

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemDisplayName() {
        return itemDisplayName;
    }

    public void setItemDisplayName(String itemDisplayName) {
        this.itemDisplayName = itemDisplayName;
    }

    public List<String> getValue() {
        return value;
    }

    public void setValue(List<String> value) {
        this.value = value;
    }

    public String getDictCode() {
        return dictCode;
    }

    public void setDictCode(String dictCode) {
        this.dictCode = dictCode;
    }

    public String getMax() {
        return max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public String getMin() {
        return min;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public Long getConfigId() {
        return configId;
    }

    public void setConfigId(Long configId) {
        this.configId = configId;
    }

    public Byte getSort() {
        return sort;
    }

    public void setSort(Byte sort) {
        this.sort = sort;
    }
}
