package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsAddTerminalResult implements Serializable {
  @JsonProperty("terminalId")
  private Long terminalId = null;

  @JsonProperty("terminalUn")
  private String terminalUn = null;

  public String getTerminalUn() {
    return terminalUn;
  }

  public void setTerminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
  }

  @JsonIgnore
  public MsAddTerminalResult terminalId(Long terminalId) {
    this.terminalId = terminalId;
    return this;
  }

   /**
   * 终端id
   * @return terminalId
  **/
  @ApiModelProperty(value = "终端id")
  public Long getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(Long terminalId) {
    this.terminalId = terminalId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAddTerminalResult addTerminalResult = (MsAddTerminalResult) o;
    return Objects.equals(this.terminalId, addTerminalResult.terminalId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(terminalId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAddTerminalResult {\n");
    
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
