package com.xforceplus.seller.config.client.model;

import java.io.Serializable;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 标准用户信息
 */
@ApiModel(description = "标准用户信息")

@JsonInclude(NON_NULL)
public class MsCommonUserInfo implements Serializable {
  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("groupName")
  private String groupName = null;

  @JsonProperty("groupCode")
  private String groupCode = null;

  @JsonProperty("orgId")
  private Long orgId = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("orgCode")
  private String orgCode = null;

  @JsonProperty("userName")
  private String userName = null;

  @JsonProperty("mobile")
  private String mobile = null;

  @JsonProperty("email")
  private String email = null;

  @JsonIgnore
  public MsCommonUserInfo groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsCommonUserInfo groupName(String groupName) {
    this.groupName = groupName;
    return this;
  }

   /**
   * 集团名称
   * @return groupName
  **/
  @ApiModelProperty(value = "集团名称")
  public String getGroupName() {
    return groupName;
  }

  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  @JsonIgnore
  public MsCommonUserInfo groupCode(String groupCode) {
    this.groupCode = groupCode;
    return this;
  }

   /**
   * 集团代码
   * @return groupCode
  **/
  @ApiModelProperty(value = "集团代码")
  public String getGroupCode() {
    return groupCode;
  }

  public void setGroupCode(String groupCode) {
    this.groupCode = groupCode;
  }

  @JsonIgnore
  public MsCommonUserInfo orgId(Long orgId) {
    this.orgId = orgId;
    return this;
  }

   /**
   * 组织机构ID
   * @return orgId
  **/
  @ApiModelProperty(value = "组织机构ID")
  public Long getOrgId() {
    return orgId;
  }

  public void setOrgId(Long orgId) {
    this.orgId = orgId;
  }

  @JsonIgnore
  public MsCommonUserInfo userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户ID
   * @return userId
  **/
  @ApiModelProperty(value = "用户ID")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsCommonUserInfo orgCode(String orgCode) {
    this.orgCode = orgCode;
    return this;
  }

   /**
   * 组织机构代码
   * @return orgCode
  **/
  @ApiModelProperty(value = "组织机构代码")
  public String getOrgCode() {
    return orgCode;
  }

  public void setOrgCode(String orgCode) {
    this.orgCode = orgCode;
  }

  @JsonIgnore
  public MsCommonUserInfo userName(String userName) {
    this.userName = userName;
    return this;
  }

   /**
   * 用户姓名
   * @return userName
  **/
  @ApiModelProperty(value = "用户姓名")
  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  @JsonIgnore
  public MsCommonUserInfo mobile(String mobile) {
    this.mobile = mobile;
    return this;
  }

   /**
   * 手机号码
   * @return mobile
  **/
  @ApiModelProperty(value = "手机号码")
  public String getMobile() {
    return mobile;
  }

  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  @JsonIgnore
  public MsCommonUserInfo email(String email) {
    this.email = email;
    return this;
  }

   /**
   * 用户邮箱
   * @return email
  **/
  @ApiModelProperty(value = "用户邮箱")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCommonUserInfo commonUserInfo = (MsCommonUserInfo) o;
    return Objects.equals(this.groupId, commonUserInfo.groupId) &&
        Objects.equals(this.groupName, commonUserInfo.groupName) &&
        Objects.equals(this.groupCode, commonUserInfo.groupCode) &&
        Objects.equals(this.orgId, commonUserInfo.orgId) &&
        Objects.equals(this.userId, commonUserInfo.userId) &&
        Objects.equals(this.orgCode, commonUserInfo.orgCode) &&
        Objects.equals(this.userName, commonUserInfo.userName) &&
        Objects.equals(this.mobile, commonUserInfo.mobile) &&
        Objects.equals(this.email, commonUserInfo.email);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupId, groupName, groupCode, orgId, userId, orgCode, userName, mobile, email);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCommonUserInfo {\n");
    
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    groupName: ").append(toIndentedString(groupName)).append("\n");
    sb.append("    groupCode: ").append(toIndentedString(groupCode)).append("\n");
    sb.append("    orgId: ").append(toIndentedString(orgId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    orgCode: ").append(toIndentedString(orgCode)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("    mobile: ").append(toIndentedString(mobile)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
