package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsRequestHead;
import com.xforceplus.seller.config.client.model.MsTerminalInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsConfigAddTerminalRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigAddTerminalRequest {
  @JsonProperty("head")
  private MsRequestHead head = null;

  @JsonProperty("terminalInfo")
  private MsTerminalInfo terminalInfo = null;

  @JsonIgnore
  public MsConfigAddTerminalRequest head(MsRequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/
  @ApiModelProperty(value = "标准请求头信息")
  public MsRequestHead getHead() {
    return head;
  }

  public void setHead(MsRequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public MsConfigAddTerminalRequest terminalInfo(MsTerminalInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
    return this;
  }

   /**
   * 终端信息
   * @return terminalInfo
  **/
  @ApiModelProperty(value = "终端信息")
  public MsTerminalInfo getTerminalInfo() {
    return terminalInfo;
  }

  public void setTerminalInfo(MsTerminalInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigAddTerminalRequest configAddTerminalRequest = (MsConfigAddTerminalRequest) o;
    return Objects.equals(this.head, configAddTerminalRequest.head) &&
        Objects.equals(this.terminalInfo, configAddTerminalRequest.terminalInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, terminalInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigAddTerminalRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    terminalInfo: ").append(toIndentedString(terminalInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
