package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsUpdateDeviceInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsConfigDeviceUpdateRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigDeviceUpdateRequest {
  @JsonProperty("deviceInfo")
  private MsUpdateDeviceInfo deviceInfo = null;

  @JsonIgnore
  public MsConfigDeviceUpdateRequest deviceInfo(MsUpdateDeviceInfo deviceInfo) {
    this.deviceInfo = deviceInfo;
    return this;
  }

   /**
   * 更新的设备信息
   * @return deviceInfo
  **/
  @ApiModelProperty(value = "更新的设备信息")
  public MsUpdateDeviceInfo getDeviceInfo() {
    return deviceInfo;
  }

  public void setDeviceInfo(MsUpdateDeviceInfo deviceInfo) {
    this.deviceInfo = deviceInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigDeviceUpdateRequest configDeviceUpdateRequest = (MsConfigDeviceUpdateRequest) o;
    return Objects.equals(this.deviceInfo, configDeviceUpdateRequest.deviceInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deviceInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigDeviceUpdateRequest {\n");
    
    sb.append("    deviceInfo: ").append(toIndentedString(deviceInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
