package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsConfigSendLicenseRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigSendLicenseRequest {
  @JsonProperty("licenseType")
  private Integer licenseType = null;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("un")
  private String un = null;

  @JsonProperty("receiverEmail")
  private String receiverEmail = null;

  @JsonProperty("operateInfo")
  private MsOperateInfo operateInfo = null;

  public String getUn() {
    return un;
  }

  public void setUn(String un) {
    this.un = un;
  }

  @JsonIgnore
  public MsConfigSendLicenseRequest licenseType(Integer licenseType) {
    this.licenseType = licenseType;
    return this;
  }

   /**
   * 1 设备，2 终端
   * @return licenseType
  **/
  @ApiModelProperty(value = "1 设备，2 终端")
  public Integer getLicenseType() {
    return licenseType;
  }

  public void setLicenseType(Integer licenseType) {
    this.licenseType = licenseType;
  }

  @JsonIgnore
  public MsConfigSendLicenseRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 申请对象的id
   * @return id
  **/
  @ApiModelProperty(value = "申请对象的id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsConfigSendLicenseRequest receiverEmail(String receiverEmail) {
    this.receiverEmail = receiverEmail;
    return this;
  }

   /**
   * 接收者邮箱
   * @return receiverEmail
  **/
  @ApiModelProperty(value = "接收者邮箱")
  public String getReceiverEmail() {
    return receiverEmail;
  }

  public void setReceiverEmail(String receiverEmail) {
    this.receiverEmail = receiverEmail;
  }

  @JsonIgnore
  public MsConfigSendLicenseRequest operateInfo(MsOperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/
  @ApiModelProperty(value = "操作信息")
  public MsOperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(MsOperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigSendLicenseRequest configSendLicenseRequest = (MsConfigSendLicenseRequest) o;
    return Objects.equals(this.licenseType, configSendLicenseRequest.licenseType) &&
        Objects.equals(this.id, configSendLicenseRequest.id) &&
        Objects.equals(this.receiverEmail, configSendLicenseRequest.receiverEmail) &&
        Objects.equals(this.operateInfo, configSendLicenseRequest.operateInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(licenseType, id, receiverEmail, operateInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigSendLicenseRequest {\n");
    
    sb.append("    licenseType: ").append(toIndentedString(licenseType)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    receiverEmail: ").append(toIndentedString(receiverEmail)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
