package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsLicenseInfo;
import com.xforceplus.seller.config.client.model.MsOperateInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsConfigUpdateDeviceStatusRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigUpdateDeviceStatusRequest {
  @JsonProperty("deviceId")
  private List<Long> deviceId = new ArrayList<Long>();

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("operateInfo")
  private MsOperateInfo operateInfo = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("licenseInfo")
  private MsLicenseInfo licenseInfo = null;

  @JsonIgnore
  public MsConfigUpdateDeviceStatusRequest deviceId(List<Long> deviceId) {
    this.deviceId = deviceId;
    return this;
  }

  public MsConfigUpdateDeviceStatusRequest addDeviceIdItem(Long deviceIdItem) {
    this.deviceId.add(deviceIdItem);
    return this;
  }

   /**
   * 设备id
   * @return deviceId
  **/
  @ApiModelProperty(value = "设备id")
  public List<Long> getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(List<Long> deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public MsConfigUpdateDeviceStatusRequest remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public MsConfigUpdateDeviceStatusRequest operateInfo(MsOperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/
  @ApiModelProperty(value = "操作信息")
  public MsOperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(MsOperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }

  @JsonIgnore
  public MsConfigUpdateDeviceStatusRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 设备状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用 22：作废）
   * @return status
  **/
  @ApiModelProperty(value = "设备状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用 22：作废）")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsConfigUpdateDeviceStatusRequest licenseInfo(MsLicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
    return this;
  }

   /**
   * 授权文件信息
   * @return licenseInfo
  **/
  @ApiModelProperty(value = "授权文件信息")
  public MsLicenseInfo getLicenseInfo() {
    return licenseInfo;
  }

  public void setLicenseInfo(MsLicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigUpdateDeviceStatusRequest configUpdateDeviceStatusRequest = (MsConfigUpdateDeviceStatusRequest) o;
    return Objects.equals(this.deviceId, configUpdateDeviceStatusRequest.deviceId) &&
        Objects.equals(this.remark, configUpdateDeviceStatusRequest.remark) &&
        Objects.equals(this.operateInfo, configUpdateDeviceStatusRequest.operateInfo) &&
        Objects.equals(this.status, configUpdateDeviceStatusRequest.status) &&
        Objects.equals(this.licenseInfo, configUpdateDeviceStatusRequest.licenseInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deviceId, remark, operateInfo, status, licenseInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigUpdateDeviceStatusRequest {\n");
    
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    licenseInfo: ").append(toIndentedString(licenseInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
