package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsDeviceQueryInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsDeviceSummaryQueryRequest
 */

@JsonInclude(NON_NULL)
public class MsDeviceSummaryQueryRequest {
  @JsonProperty("queryInfo")
  private MsDeviceQueryInfo queryInfo = null;

  @JsonIgnore
  public MsDeviceSummaryQueryRequest queryInfo(MsDeviceQueryInfo queryInfo) {
    this.queryInfo = queryInfo;
    return this;
  }

   /**
   * 查询信息
   * @return queryInfo
  **/
  @ApiModelProperty(value = "查询信息")
  public MsDeviceQueryInfo getQueryInfo() {
    return queryInfo;
  }

  public void setQueryInfo(MsDeviceQueryInfo queryInfo) {
    this.queryInfo = queryInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDeviceSummaryQueryRequest deviceSummaryQueryRequest = (MsDeviceSummaryQueryRequest) o;
    return Objects.equals(this.queryInfo, deviceSummaryQueryRequest.queryInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(queryInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDeviceSummaryQueryRequest {\n");
    
    sb.append("    queryInfo: ").append(toIndentedString(queryInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
