package com.xforceplus.seller.config.client.model;

import java.io.Serializable;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsEnumBean implements Serializable {
  @JsonProperty("code")
  private String code = null;

  @JsonProperty("value")
  private String value = null;

  @JsonProperty("text")
  private String text = null;

  @JsonProperty("fieldGroupIndex")
  private String fieldGroupIndex = null;

  @JsonProperty("defaultflag")
  private Integer defaultflag = 0;

  @JsonIgnore
  public MsEnumBean code(String code) {
    this.code = code;
    return this;
  }

   /**
   * null
   * @return code
  **/
  @ApiModelProperty(value = "null")
  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  @JsonIgnore
  public MsEnumBean value(String value) {
    this.value = value;
    return this;
  }

   /**
   * null
   * @return value
  **/
  @ApiModelProperty(value = "null")
  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  @JsonIgnore
  public MsEnumBean text(String text) {
    this.text = text;
    return this;
  }

   /**
   * null
   * @return text
  **/
  @ApiModelProperty(value = "null")
  public String getText() {
    return text;
  }

  public void setText(String text) {
    this.text = text;
  }

  @JsonIgnore
  public MsEnumBean fieldGroupIndex(String fieldGroupIndex) {
    this.fieldGroupIndex = fieldGroupIndex;
    return this;
  }

   /**
   * null
   * @return fieldGroupIndex
  **/
  @ApiModelProperty(value = "null")
  public String getFieldGroupIndex() {
    return fieldGroupIndex;
  }

  public void setFieldGroupIndex(String fieldGroupIndex) {
    this.fieldGroupIndex = fieldGroupIndex;
  }

  @JsonIgnore
  public MsEnumBean defaultflag(Integer defaultflag) {
    this.defaultflag = defaultflag;
    return this;
  }

   /**
   * 是否默认值
   * @return defaultflag
  **/
  @ApiModelProperty(value = "是否默认值")
  public Integer getDefaultflag() {
    return defaultflag;
  }

  public void setDefaultflag(Integer defaultflag) {
    this.defaultflag = defaultflag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsEnumBean enumBean = (MsEnumBean) o;
    return Objects.equals(this.code, enumBean.code) &&
        Objects.equals(this.value, enumBean.value) &&
        Objects.equals(this.text, enumBean.text) &&
        Objects.equals(this.fieldGroupIndex, enumBean.fieldGroupIndex) &&
        Objects.equals(this.defaultflag, enumBean.defaultflag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, value, text, fieldGroupIndex, defaultflag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsEnumBean {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    fieldGroupIndex: ").append(toIndentedString(fieldGroupIndex)).append("\n");
    sb.append("    defaultflag: ").append(toIndentedString(defaultflag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
