package com.xforceplus.seller.config.client.model;

import java.io.Serializable;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票类型结果
 */
@ApiModel(description = "发票类型结果")

@JsonInclude(NON_NULL)
public class MsInvoiceTypeResult implements Serializable {
  @JsonProperty("invoceTypes")
  private List<String> invoceTypes = new ArrayList<String>();

  @JsonIgnore
  public MsInvoiceTypeResult invoceTypes(List<String> invoceTypes) {
    this.invoceTypes = invoceTypes;
    return this;
  }

  public MsInvoiceTypeResult addInvoceTypesItem(String invoceTypesItem) {
    this.invoceTypes.add(invoceTypesItem);
    return this;
  }

   /**
   * 发票类型
   * @return invoceTypes
  **/
  @ApiModelProperty(value = "发票类型")
  public List<String> getInvoceTypes() {
    return invoceTypes;
  }

  public void setInvoceTypes(List<String> invoceTypes) {
    this.invoceTypes = invoceTypes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceTypeResult invoiceTypeResult = (MsInvoiceTypeResult) o;
    return Objects.equals(this.invoceTypes, invoiceTypeResult.invoceTypes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoceTypes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceTypeResult {\n");
    
    sb.append("    invoceTypes: ").append(toIndentedString(invoceTypes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
