package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsBusinessObjBean;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsMataDataAddRequestWithUserInfo {
  @JsonProperty("objId")
  private Long objId = null;

  @JsonProperty("itemDTOList")
  private List<MsBusinessObjBean> itemDTOList = new ArrayList<MsBusinessObjBean>();

  @JsonProperty("userInfo")
  private MsCommonUserInfo userInfo = null;

  @JsonIgnore
  public MsMataDataAddRequestWithUserInfo objId(Long objId) {
    this.objId = objId;
    return this;
  }

   /**
   * 对象ID
   * @return objId
  **/
  @ApiModelProperty(value = "对象ID")
  public Long getObjId() {
    return objId;
  }

  public void setObjId(Long objId) {
    this.objId = objId;
  }

  @JsonIgnore
  public MsMataDataAddRequestWithUserInfo itemDTOList(List<MsBusinessObjBean> itemDTOList) {
    this.itemDTOList = itemDTOList;
    return this;
  }

  public MsMataDataAddRequestWithUserInfo addItemDTOListItem(MsBusinessObjBean itemDTOListItem) {
    this.itemDTOList.add(itemDTOListItem);
    return this;
  }

   /**
   * Get itemDTOList
   * @return itemDTOList
  **/
  @ApiModelProperty(value = "")
  public List<MsBusinessObjBean> getItemDTOList() {
    return itemDTOList;
  }

  public void setItemDTOList(List<MsBusinessObjBean> itemDTOList) {
    this.itemDTOList = itemDTOList;
  }

  @JsonIgnore
  public MsMataDataAddRequestWithUserInfo userInfo(MsCommonUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * 用户信息
   * @return userInfo
  **/
  @ApiModelProperty(value = "用户信息")
  public MsCommonUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsCommonUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsMataDataAddRequestWithUserInfo mataDataAddRequestWithUserInfo = (MsMataDataAddRequestWithUserInfo) o;
    return Objects.equals(this.objId, mataDataAddRequestWithUserInfo.objId) &&
        Objects.equals(this.itemDTOList, mataDataAddRequestWithUserInfo.itemDTOList) &&
        Objects.equals(this.userInfo, mataDataAddRequestWithUserInfo.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(objId, itemDTOList, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsMataDataAddRequestWithUserInfo {\n");
    
    sb.append("    objId: ").append(toIndentedString(objId)).append("\n");
    sb.append("    itemDTOList: ").append(toIndentedString(itemDTOList)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
