package com.xforceplus.seller.config.client.model;

import java.io.Serializable;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsQueryDeviceResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsQueryDeviceResponse
 */

@JsonInclude(NON_NULL)
public class MsQueryDeviceResponse implements Serializable {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private MsQueryDeviceResult result = null;

  @JsonIgnore
  public MsQueryDeviceResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 返回结果状态（1：成功 0：失败）
   * @return code
  **/
  @ApiModelProperty(value = "返回结果状态（1：成功 0：失败）")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsQueryDeviceResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * 返回信息
   * @return message
  **/
  @ApiModelProperty(value = "返回信息")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsQueryDeviceResponse result(MsQueryDeviceResult result) {
    this.result = result;
    return this;
  }

   /**
   * 返回结果内容
   * @return result
  **/
  @ApiModelProperty(value = "返回结果内容")
  public MsQueryDeviceResult getResult() {
    return result;
  }

  public void setResult(MsQueryDeviceResult result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsQueryDeviceResponse queryDeviceResponse = (MsQueryDeviceResponse) o;
    return Objects.equals(this.code, queryDeviceResponse.code) &&
        Objects.equals(this.message, queryDeviceResponse.message) &&
        Objects.equals(this.result, queryDeviceResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsQueryDeviceResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
