package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsQueryInvoiceTitleRequest {
  @ApiModelProperty(value = "销方名称")
  @JsonProperty("sellerName")
  private String sellerName = null;

  @ApiModelProperty(value = "销方税号")
  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @ApiModelProperty(value = "销方电话")
  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @ApiModelProperty(value = "销方银行名称")
  @JsonProperty("sellerBankName")
  private String sellerBankName = null;

  @ApiModelProperty(value = "销方银行名称")
  @JsonProperty("sellerGroupId")
  private Long sellerGroupId;

  @ApiModelProperty(value = "抬头信息状态，1：有效，9：删除")
  @JsonProperty("status")
  private Integer status;

  @JsonProperty("pageNo")
  private Integer pageNo = 1;

  @JsonProperty("pageSize")
  private Integer pageSize = 10;

  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  public Long getSellerGroupId() {
    return sellerGroupId;
  }

  public void setSellerGroupId(Long sellerGroupId) {
    this.sellerGroupId = sellerGroupId;
  }

  public String getSellerTel() {
    return sellerTel;
  }

  public void setSellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
  }

  public String getSellerBankName() {
    return sellerBankName;
  }

  public void setSellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
  }

  @Override
  public String toString() {
    return "MsQueryInvoiceTitleRequest{" +
            "sellerName='" + sellerName + '\'' +
            ", sellerTaxNo='" + sellerTaxNo + '\'' +
            ", sellerTel='" + sellerTel + '\'' +
            ", sellerBankName='" + sellerBankName + '\'' +
            ", sellerGroupId=" + sellerGroupId +
            ", status=" + status +
            ", pageNo=" + pageNo +
            ", pageSize=" + pageSize +
            '}';
  }
}
