package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 终端信息
 */
@ApiModel(description = "终端信息")

@JsonInclude(NON_NULL)
public class MsTerminalInfo implements Serializable {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonProperty("deviceUn")
  private String deviceUn = null;

  @JsonProperty("companyInfo")
  private MsCompanyInfo companyInfo = null;

  @JsonProperty("operateInfo")
  private MsOperateInfo operateInfo = null;

  @JsonProperty("terminalNo")
  private String terminalNo = null;

  @JsonProperty("terminalName")
  private String terminalName = null;

  @JsonProperty("terminalType")
  private Integer terminalType = null;

  @JsonProperty("invoiceType")
  private List<String> invoiceType = new ArrayList<String>();

  @JsonProperty("supportService")
  private List<String> supportService = new ArrayList<String>();

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("paddingLeft")
  private Integer paddingLeft = null;

  @JsonProperty("paddingTop")
  private Integer paddingTop = null;

  @JsonProperty("printInvoiceTerminalId")
  private Long printInvoiceTerminalId = null;

  @JsonProperty("printSaleListTerminalId")
  private Long printSaleListTerminalId = null;

  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  @JsonIgnore
  public MsTerminalInfo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 终端id
   * @return id
  **/
  @ApiModelProperty(value = "终端id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsTerminalInfo deviceId(Long deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 设备id，服务器终端时传入
   * @return deviceId
  **/
  @ApiModelProperty(value = "设备id，服务器终端时传入")
  public Long getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(Long deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public MsTerminalInfo companyInfo(MsCompanyInfo companyInfo) {
    this.companyInfo = companyInfo;
    return this;
  }

   /**
   * 公司信息
   * @return companyInfo
  **/
  @ApiModelProperty(value = "公司信息")
  public MsCompanyInfo getCompanyInfo() {
    return companyInfo;
  }

  public void setCompanyInfo(MsCompanyInfo companyInfo) {
    this.companyInfo = companyInfo;
  }

  @JsonIgnore
  public MsTerminalInfo operateInfo(MsOperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/
  @ApiModelProperty(value = "操作信息")
  public MsOperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(MsOperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }

  @JsonIgnore
  public MsTerminalInfo terminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
    return this;
  }

   /**
   * 终端编号
   * @return terminalNo
  **/
  @ApiModelProperty(value = "终端编号")
  public String getTerminalNo() {
    return terminalNo;
  }

  public void setTerminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
  }

  @JsonIgnore
  public MsTerminalInfo terminalName(String terminalName) {
    this.terminalName = terminalName;
    return this;
  }

   /**
   * 终端名称
   * @return terminalName
  **/
  @ApiModelProperty(value = "终端名称")
  public String getTerminalName() {
    return terminalName;
  }

  public void setTerminalName(String terminalName) {
    this.terminalName = terminalName;
  }

  @JsonIgnore
  public MsTerminalInfo terminalType(Integer terminalType) {
    this.terminalType = terminalType;
    return this;
  }

   /**
   * 终端类型 1：单盘 2：服务器
   * @return terminalType
  **/
  @ApiModelProperty(value = "终端类型 1：单盘 2：服务器")
  public Integer getTerminalType() {
    return terminalType;
  }

  public void setTerminalType(Integer terminalType) {
    this.terminalType = terminalType;
  }

  @JsonIgnore
  public MsTerminalInfo invoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

  public MsTerminalInfo addInvoiceTypeItem(String invoiceTypeItem) {
    this.invoiceType.add(invoiceTypeItem);
    return this;
  }

   /**
   * 发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）")
  public List<String> getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsTerminalInfo supportService(List<String> supportService) {
    this.supportService = supportService;
    return this;
  }

  public MsTerminalInfo addSupportServiceItem(String supportServiceItem) {
    this.supportService.add(supportServiceItem);
    return this;
  }

   /**
   * 支持的服务（print:打印 make:开票,originAccount:底账）
   * @return supportService
  **/
  @ApiModelProperty(value = "支持的服务（print:打印 make:开票,originAccount:底账）")
  public List<String> getSupportService() {
    return supportService;
  }

  public void setSupportService(List<String> supportService) {
    this.supportService = supportService;
  }

  @JsonIgnore
  public MsTerminalInfo status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用 22：作废）
   * @return status
  **/
  @ApiModelProperty(value = "状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用 22：作废）")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsTerminalInfo paddingLeft(Integer paddingLeft) {
    this.paddingLeft = paddingLeft;
    return this;
  }

   /**
   * 左边距
   * @return paddingLeft
  **/
  @ApiModelProperty(value = "左边距")
  public Integer getPaddingLeft() {
    return paddingLeft;
  }

  public void setPaddingLeft(Integer paddingLeft) {
    this.paddingLeft = paddingLeft;
  }

  @JsonIgnore
  public MsTerminalInfo paddingTop(Integer paddingTop) {
    this.paddingTop = paddingTop;
    return this;
  }

   /**
   * 上边距
   * @return paddingTop
  **/
  @ApiModelProperty(value = "上边距")
  public Integer getPaddingTop() {
    return paddingTop;
  }

  public void setPaddingTop(Integer paddingTop) {
    this.paddingTop = paddingTop;
  }

  @JsonIgnore
  public MsTerminalInfo printInvoiceTerminalId(Long printInvoiceTerminalId) {
    this.printInvoiceTerminalId = printInvoiceTerminalId;
    return this;
  }

   /**
   * 打印发票终端id
   * @return printInvoiceTerminalId
  **/
  @ApiModelProperty(value = "打印发票终端id")
  public Long getPrintInvoiceTerminalId() {
    return printInvoiceTerminalId;
  }

  public void setPrintInvoiceTerminalId(Long printInvoiceTerminalId) {
    this.printInvoiceTerminalId = printInvoiceTerminalId;
  }

  @JsonIgnore
  public MsTerminalInfo printSaleListTerminalId(Long printSaleListTerminalId) {
    this.printSaleListTerminalId = printSaleListTerminalId;
    return this;
  }

   /**
   * 打印销货清单终端id
   * @return printSaleListTerminalId
  **/
  @ApiModelProperty(value = "打印销货清单终端id")
  public Long getPrintSaleListTerminalId() {
    return printSaleListTerminalId;
  }

  public void setPrintSaleListTerminalId(Long printSaleListTerminalId) {
    this.printSaleListTerminalId = printSaleListTerminalId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTerminalInfo terminalInfo = (MsTerminalInfo) o;
    return Objects.equals(this.id, terminalInfo.id) &&
        Objects.equals(this.deviceId, terminalInfo.deviceId) &&
        Objects.equals(this.companyInfo, terminalInfo.companyInfo) &&
        Objects.equals(this.operateInfo, terminalInfo.operateInfo) &&
        Objects.equals(this.terminalNo, terminalInfo.terminalNo) &&
        Objects.equals(this.terminalName, terminalInfo.terminalName) &&
        Objects.equals(this.terminalType, terminalInfo.terminalType) &&
        Objects.equals(this.invoiceType, terminalInfo.invoiceType) &&
        Objects.equals(this.supportService, terminalInfo.supportService) &&
        Objects.equals(this.status, terminalInfo.status) &&
        Objects.equals(this.paddingLeft, terminalInfo.paddingLeft) &&
        Objects.equals(this.paddingTop, terminalInfo.paddingTop) &&
        Objects.equals(this.printInvoiceTerminalId, terminalInfo.printInvoiceTerminalId) &&
        Objects.equals(this.printSaleListTerminalId, terminalInfo.printSaleListTerminalId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, deviceId, companyInfo, operateInfo, terminalNo, terminalName, terminalType, invoiceType, supportService, status, paddingLeft, paddingTop, printInvoiceTerminalId, printSaleListTerminalId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTerminalInfo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    companyInfo: ").append(toIndentedString(companyInfo)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("    terminalNo: ").append(toIndentedString(terminalNo)).append("\n");
    sb.append("    terminalName: ").append(toIndentedString(terminalName)).append("\n");
    sb.append("    terminalType: ").append(toIndentedString(terminalType)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    supportService: ").append(toIndentedString(supportService)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    paddingLeft: ").append(toIndentedString(paddingLeft)).append("\n");
    sb.append("    paddingTop: ").append(toIndentedString(paddingTop)).append("\n");
    sb.append("    printInvoiceTerminalId: ").append(toIndentedString(printInvoiceTerminalId)).append("\n");
    sb.append("    printSaleListTerminalId: ").append(toIndentedString(printSaleListTerminalId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
