package com.xforceplus.seller.config.client.model;

import java.io.Serializable;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsResponsePageInfo;
import com.xforceplus.seller.config.client.model.MsTerminalQueryResponseInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 终端查询结果
 */
@ApiModel(description = "终端查询结果")

@JsonInclude(NON_NULL)
public class MsTerminalQueryResponse implements Serializable {
  @JsonProperty("terminals")
  private MsTerminalQueryResponseInfo terminals = null;

  @JsonProperty("pageInfo")
  private MsResponsePageInfo pageInfo = null;

  @JsonIgnore
  public MsTerminalQueryResponse terminals(MsTerminalQueryResponseInfo terminals) {
    this.terminals = terminals;
    return this;
  }

   /**
   * 终端信息
   * @return terminals
  **/
  @ApiModelProperty(value = "终端信息")
  public MsTerminalQueryResponseInfo getTerminals() {
    return terminals;
  }

  public void setTerminals(MsTerminalQueryResponseInfo terminals) {
    this.terminals = terminals;
  }

  @JsonIgnore
  public MsTerminalQueryResponse pageInfo(MsResponsePageInfo pageInfo) {
    this.pageInfo = pageInfo;
    return this;
  }

   /**
   * 分页信息
   * @return pageInfo
  **/
  @ApiModelProperty(value = "分页信息")
  public MsResponsePageInfo getPageInfo() {
    return pageInfo;
  }

  public void setPageInfo(MsResponsePageInfo pageInfo) {
    this.pageInfo = pageInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTerminalQueryResponse terminalQueryResponse = (MsTerminalQueryResponse) o;
    return Objects.equals(this.terminals, terminalQueryResponse.terminals) &&
        Objects.equals(this.pageInfo, terminalQueryResponse.pageInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(terminals, pageInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTerminalQueryResponse {\n");
    
    sb.append("    terminals: ").append(toIndentedString(terminals)).append("\n");
    sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
